package test.org.itscool.commons.document2;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

import org.itscool.commons.document.BeanToXmlDocument;
import org.itscool.commons.document.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanToXmlDocumentTest extends TestCase{
    
    /**
     * NX̌pɑ΂XMLJavaBeans}bsOeXg
     */
    public void testParseList(){
        SampleSubBean2 bean = new SampleSubBean2();
        bean.setId(1);
        bean.setName("ق@낤");
        bean.setAddr("{ ؎s...");
        bean.setTel("090-0000-1234");
        
        try{
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            
            //}bsO`
            beanToXml.replaceClassToTagName(SampleSubBean2.class.getName(), "sample_sub_bean");
            
            //IuWFNgǉ
            beanToXml.addElement(bean);
            
            Document document = beanToXml.getDocument();
            
            String text = beanToXml.parseTextIndent("utf-8");
            System.out.println("---- test2 start ----");
            System.out.println(text);
            System.out.println("---- test2 end ----");
            
            DomParser parser = new DomParser(document);
            
            NodeList beanNodes = parser.getElementsByTagNames("root.sample_sub_bean" );
            
            assertEquals("bean num", beanNodes.getLength(), 1);
            Node beanNode = beanNodes.item(0);
            String beanTagName = beanNode.getNodeName();
            String id = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "id");
            String name = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "name");
            String addr = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "addr");
            String tel = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "tel");
            
            assertEquals("beanName", beanTagName, "sample_sub_bean");
            assertEquals("id", id, "1");
            assertEquals("name", name, "ق@낤");
            assertEquals("addr", addr, "{ ؎s...");
            assertEquals("tel", tel, "090-0000-1234");
            
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
}
