/*
 * SamplePrepare.java
 *
 * Created on 2007/04/12, 13:51
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.dao.preperd;

import java.io.IOException;
import java.util.List;
import org.itscool.commons.dao.PreparedStatementWrapper;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.User;

/**
 * PreparedStatementWrapperɂOR}bsÕeXg
 */
public class PrepareTest2 extends WeberDbTestCase{
    public PrepareTest2(){
        this.initTables("test/org/itscool/commons/dao/preperd/test-db-data.xml");
    }
    
    /**
     * Pf[^̎擾
     */
    public void testSelect(){
        String sql = "SELECT * FROM ROLE WHERE NAME = ?";
        PreparedStatementWrapper mapper = TransactionUtil.getPreparedStatementWrapper(sql);
        mapper.setValue(1, "admin");
        List result = mapper.select(Role.class);
        
        assertEquals("hit num", 1, result.size());
        
        for( int i=0; i<result.size(); i++){
            Role role = (Role)result.get(i);
            assertEquals("role-id", 1, role.getId());
            assertEquals("role-name", "admin", role.getName());
        }
    }
    
    /**
     * OQƃf[^̎擾
     */
    public void testSelect2(){
        String sql = "SELECT U.ID, U.NAME,U.ROLE_ID, R.ID, R.NAME  FROM USER U, ROLE R WHERE NAME = ? AND U.ROLE_ID = R.ID";
        PreparedStatementWrapper mapper = TransactionUtil.getPreparedStatementWrapper(sql);
        mapper.setValue(1, "kano");
        List result = mapper.select(User.class);
        
        assertEquals("hit num", 1, result.size());
        
        User user = (User)result.get(0);
        if( user == null ) fail("user is null");
        assertEquals("user-id", 4, user.getId());
        assertEquals("user-name", "kano", user.getName());
        assertEquals("user-roleId", 2, user.getRoleId());
        
        Role role = user.getRole();
        if( role == null ) fail("role is null");
        assertEquals("role-id", 2, role.getId());
        System.out.println("ROLE_NAME:" + role.getName());
        assertEquals("role-name", "guest", role.getName());
        
    }
    
}
