package test.org.itscool.commons.dao.criteria;

import junit.framework.TestCase;
import org.itscool.commons.dao.*;

/**
 * 쐬: 2005/06/22
 * @author kanoum
 */
public class Criteria8Test extends TestCase{
    public Criteria8Test(String name){
        super(name);
    }
    
    public void testSelect1(){
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq("name", "^Cg").or().eq("name", "^Cg1");
        crt.orderby("id", true).orderby("name", true);
        
        System.out.println(crt.toSelectString());
    }
    
    public void testSelect2(){
        Criteria crt = new Criteria(AutorBean1.class);
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
    }
    
    public void testSelect3(){
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq("autorId", 1).or().eq("name", "䂵");
        crt.orderby("id", true).orderby("name", false);
        System.out.println(crt.toSelectString());
    }
    
    public void testUpdateSqlDirect1(){
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq("id", 120);
        StringBuffer sb = new StringBuffer();
        String line = System.getProperty("line.separator");
        
        sb.append("UPDATE BOOK").append(line);
        sb.append("SET ").append(line);
        sb.append("    NAME='{n}',").append(line);
        sb.append("    AUTOR_ID=100,").append(line);
        sb.append("    ID=0").append(line);
        sb.append("WHERE").append(line);
        sb.append("    BOOK.ID = 120");
        
        BookBean1 book = new BookBean1();
        book.setName("{n}");
        book.setAutorId(100);
        String result = crt.toUpdateString(book);
        if( !result.equals(sb.toString())){
            System.out.println("test->" + sb.toString());
            System.out.println("result->" + result);
        }
        assertEquals(result, sb.toString());
    }
    
    public void testSelectSqlDirect(){
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    BOOK.NAME as BOOK_NAME,").append(line);
        sb.append("    BOOK.AUTOR_ID as BOOK_AUTOR_ID,").append(line);
        sb.append("    BOOK.ID as BOOK_ID").append(line);
        sb.append("FROM").append(line);
        sb.append("    BOOK").append(line);
        sb.append("WHERE").append(line);
        sb.append("    autor_id = 1").append(line);
        sb.append("    OR BOOK.NAME = '䂵'").append(line);
        sb.append("ORDER BY").append(line);
        sb.append("    BOOK.ID ASC,").append(line);
        sb.append("    BOOK.NAME DESC");
        
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq(BookBean1.COLUM_autorId, 1).or().eq(BookBean1.COLUM_name, "䂵");
        crt.orderby("id", true).orderby("name", false);
        
        String result = crt.toSelectString();
        if( !result.equals(sb.toString())){
            System.out.println("test->" + sb.toString());
            System.out.println("result->" + result);
        }
        assertEquals(result, sb.toString());
    }
    
}
