package weber_4_0_sample.org.itscool.hello;

import java.util.ArrayList;
import org.itscool.commons.util.InputCheckUtil;

import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.controller.Globals;

public class HelloShowAction extends Action{
    //̓`FbN
    public String doValidate(ActionBucket bucket){
        String ret = Globals.RET_SUCCESS;
        String name = (String)this.getParameter("name");
        String age = (String)this.getParameter("age");
        if (!InputCheckUtil.isNotNull(name)) {
            putMessage("name","O͂Ă");
            ret = "input";
        }else if(!InputCheckUtil.checkSmallAlphabet(name)){
            putMessage("name","O͔ppœ͂Ă");
            ret = "input";
        }
        if(!InputCheckUtil.isNotNull(age)){
            putMessage("age","N͂Ă");
            ret = "input";
        }else if(!InputCheckUtil.checkDigit(age)){
            putMessage("age","N͔p͂Ă");
            ret = "input";
        }
        return ret;
    }
    
    public String doExecute(ActionBucket bucket){
        System.out.println(bucket.getRealPath("."));
        
        Hello hello = (Hello)bucket.getForm();
        String newName = hello.getName().toUpperCase();
        hello.setName(newName);
        
        bucket.setAttribute("hello", hello);
        
        ArrayList personList = (ArrayList)bucket.getAttributeFromSession("personList");
        if( personList == null){
        	personList = new ArrayList();
        	bucket.setAttributeFromSession("personList", personList);
        }
        personList.add(hello);
        return "show";
    }
}

