/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.itscool.commons.document.AbstractDocument;
import org.itscool.commons.document.DocumentBean;
import org.itscool.commons.document.DocumentBeanParser;

public class BeanToJsonDocument
extends AbstractDocument {
    private String LINE = System.getProperty("line.separator");
    private ArrayList pBeanList = new ArrayList();
    private String rootName;

    public BeanToJsonDocument(String rootName) {
        this.rootName = rootName;
    }

    public void addElement(Object bean) throws Exception {
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
        this.addElement(pBean);
    }

    public void addElement(List list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object bean = list.get(i);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
            this.addElement(pBean);
        }
    }

    public void addElement(Map map) throws Exception {
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object bean = map.get(key);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
            this.addElement(pBean);
        }
    }

    protected void addElement(DocumentBean pBean) throws Exception {
        this.pBeanList.add(pBean);
    }

    public String parseText() {
        StringBuffer sb = new StringBuffer("{\"" + this.rootName + "\":");
        int size = this.pBeanList.size();
        for (int i = 0; i < size; ++i) {
            DocumentBean dBean = (DocumentBean)this.pBeanList.get(i);
            sb.append("{");
            int dBeanSize = dBean.size();
            if (dBeanSize > 1) {
                for (int j = 0; j < dBeanSize; ++j) {
                    DocumentBean child = (DocumentBean)dBean.get(j);
                    String value = this.parseText(child, child.getName());
                    sb.append(value);
                    if (j + 1 >= dBeanSize) continue;
                    sb.append(",");
                }
            } else {
                String name = dBean.getName();
                String value = (String)dBean.getValue();
                sb.append("\"" + name + "\":");
                sb.append("\"" + value + "\"");
            }
            sb.append("}");
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public String parseText(DocumentBean dBean, String parentName) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"" + parentName + "\":");
        int size = this.pBeanList.size();
        int dBeanSize = dBean.size();
        if (dBeanSize > 1) {
            sb.append("{");
            for (int j = 0; j < dBeanSize; ++j) {
                DocumentBean child = (DocumentBean)dBean.get(j);
                String value = this.parseText(child, child.getName());
                sb.append(value);
                if (j >= dBeanSize - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("\"").append(dBean.getValue()).append("\"");
        }
        return sb.toString();
    }
}

