/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.EntityInfo;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;
import org.itscool.commons.dao.RecordMapOneToManyFactory;
import org.itscool.commons.logging.AbstractLog;

public class EntityInfoMapping {
    public static final String DB_HSQL = "hsql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_PGSQL = "pgsql";
    public static final String DB_ORACLE = "oracle";
    private HashMap daoInfoMappings = new HashMap();
    private String dbType = "hsql";
    private static EntityInfoMapping instance;
    protected static AbstractLog log;

    public static synchronized EntityInfoMapping getInstance() {
        if (instance == null) {
            instance = new EntityInfoMapping();
            BeanFactory factory = BeanFactory.getInstance();
            try {
                log = (AbstractLog)factory.getInstance("Log");
                if (!log.isInit()) {
                    log = (AbstractLog)factory.createInstance("Log");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public void put(Object key, Object data) {
        this.getDaoInfoMappings().put(key, data);
    }

    public Set keySet() {
        return this.getDaoInfoMappings().keySet();
    }

    public Object get(Object key) {
        return this.getDaoInfoMappings().get(key);
    }

    public void clear() {
        this.getDaoInfoMappings().clear();
    }

    public EntityInfo getDaoInfo(String clazzName) {
        EntityInfo daoInfo = (EntityInfo)this.get(clazzName);
        return daoInfo;
    }

    public RecordMap getGRecordMap(String clazzName) {
        EntityInfo daoInfo = this.getDaoInfo(clazzName);
        if (daoInfo == null) {
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(clazzName);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(clazzName);
            HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(clazzName);
            daoInfo = new EntityInfo();
            daoInfo.setGRecordMap(gRecordMap);
            daoInfo.setFkRecordMaps(fkRecordMaps);
            daoInfo.setOneToManyRecordMaps(oneToManyRecordMaps);
            this.daoInfoMappings.put(clazzName, daoInfo);
            return gRecordMap;
        }
        RecordMap recordMap = daoInfo.getGRecordMap();
        if (recordMap == null) {
            recordMap = RecordMapFactory.createRecordMap(clazzName);
        }
        return recordMap;
    }

    public HashMap getFkRecordMaps(String clazzName) {
        EntityInfo daoInfo = this.getDaoInfo(clazzName);
        if (daoInfo == null) {
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(clazzName);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(clazzName);
            HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(clazzName);
            daoInfo = new EntityInfo();
            daoInfo.setGRecordMap(gRecordMap);
            daoInfo.setFkRecordMaps(fkRecordMaps);
            daoInfo.setOneToManyRecordMaps(oneToManyRecordMaps);
            this.daoInfoMappings.put(clazzName, daoInfo);
            return fkRecordMaps;
        }
        HashMap fkMap = daoInfo.getFkRecordMaps();
        if (fkMap == null) {
            fkMap = RecordMapFkFactory.createFkRecordMaps(clazzName);
        }
        return fkMap;
    }

    public HashMap getOneToManyRecordMaps(String clazzName) {
        EntityInfo daoInfo = this.getDaoInfo(clazzName);
        if (daoInfo == null) {
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(clazzName);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(clazzName);
            HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(clazzName);
            daoInfo = new EntityInfo();
            daoInfo.setGRecordMap(gRecordMap);
            daoInfo.setFkRecordMaps(fkRecordMaps);
            daoInfo.setOneToManyRecordMaps(oneToManyRecordMaps);
            this.daoInfoMappings.put(clazzName, daoInfo);
            return oneToManyRecordMaps;
        }
        HashMap oneToManyMap = daoInfo.getOneToManyRecordMaps();
        if (oneToManyMap == null) {
            oneToManyMap = RecordMapOneToManyFactory.createOneToManyRecordMaps(clazzName);
        }
        return oneToManyMap;
    }

    public RecordMap getGRecordMap(Class clazz) {
        return this.getGRecordMap(clazz.getName());
    }

    public HashMap getFkRecordMaps(Class clazz) {
        return this.getFkRecordMaps(clazz.getName());
    }

    public HashMap getOneToManyRecordMaps(Class clazz) {
        return this.getOneToManyRecordMaps(clazz.getName());
    }

    public HashMap getDaoInfoMappings() {
        return this.daoInfoMappings;
    }

    public RecordMap getFkRecordMap(String clazzName, String fkPropertyName) {
        HashMap fkMap = this.getFkRecordMaps(clazzName);
        RecordMap fkRecordMap = (RecordMap)fkMap.get(fkPropertyName);
        return fkRecordMap;
    }

    public RecordMap getFkRecordMap(Class clazz, String fkPropertyName) {
        return this.getFkRecordMap(clazz.getName(), fkPropertyName);
    }

    public RecordMap getOneToManyRecordMap(String clazzName, String oneToManyPropertyName) {
        HashMap oneToManyMap = this.getOneToManyRecordMaps(clazzName);
        RecordMap oneToManyRecordMap = (RecordMap)oneToManyMap.get(oneToManyPropertyName);
        return oneToManyRecordMap;
    }

    public RecordMap getOneToManyRecordMap(Class clazz, String oneToManyPropertyName) {
        return this.getOneToManyRecordMap(clazz.getName(), oneToManyPropertyName);
    }

    public void setDaoInfoMappings(HashMap daoInfoMappings) {
        String entity = "";
        try {
            Set keySet = daoInfoMappings.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                entity = (String)it.next();
                RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
                HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
                HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(entity);
                EntityInfo daoInfo = new EntityInfo();
                daoInfo.setGRecordMap(gRecordMap);
                daoInfo.setFkRecordMaps(fkRecordMaps);
                daoInfo.setOneToManyRecordMaps(oneToManyRecordMaps);
                this.daoInfoMappings.put(entity, daoInfo);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage() + " class=" + entity);
            log.error(e);
            throw new DaoRuntimeException(e.getMessage());
        }
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

