/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.List;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.AutoNumber;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;

public class AutoNumberDao
extends BaseDao {
    public int getNext(String tableName) {
        int id = 0;
        Criteria crt = new Criteria(AutoNumber.class);
        crt.eq("AUTO_NUMBER.TABLE_NAME", tableName);
        List lst = this.select(crt);
        if (lst != null && lst.size() > 0) {
            AutoNumber autoNumber = (AutoNumber)lst.get(0);
            id = this.nextAutoNumber(tableName, autoNumber);
        } else {
            id = this.newAutoNumber(tableName);
        }
        return id;
    }

    protected int nextAutoNumber(String tableName, AutoNumber autoNumber) {
        int id = autoNumber.getNextNumber() + 1;
        autoNumber.setNextNumber(id);
        Criteria crt = new Criteria(AutoNumber.class);
        crt.eq("AUTO_NUMBER.TABLE_NAME", tableName);
        this.update(crt, autoNumber);
        return id;
    }

    protected int newAutoNumber(String tableName) {
        int id = this.getCount(tableName);
        id = id < 1 ? 1 : ++id;
        AutoNumber autoNumber = new AutoNumber();
        autoNumber.setTableName(tableName);
        autoNumber.setNextNumber(id);
        Criteria crt = new Criteria(AutoNumber.class);
        this.insert(crt, autoNumber);
        return id;
    }

    public int getCount(String tableName) {
        String sql = "SELECT COUNT(*) AS DATA_NUM FROM " + tableName;
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(sql);
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        return dataNum;
    }
}

