/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;
import org.itscool.commons.request.HttpGeneralForm;
import org.itscool.commons.request.UploadFile;
import org.itscool.commons.util.ByteUtil;
import org.itscool.commons.util.URLDecodeUtil;

public class MultiHttpGeneralForm
extends HttpGeneralForm {
    public static final String DISPOSTION = "Content-Disposition";
    public static final String TYPE = "Content-Type";

    public void doParseData(byte[] buffer, String encode) {
        int pos = 0;
        int bufSize = buffer.length;
        pos = 0;
        while (pos <= bufSize) {
            byte[] data;
            byte[] header = ByteUtil.getLineCrLf(buffer, pos);
            byte[] dispostion = ByteUtil.getLineCrLf(buffer, pos += header.length + ByteUtil.LINE.length);
            byte[] type = ByteUtil.getLineCrLf(buffer, pos += dispostion.length + ByteUtil.LINE.length);
            pos += type.length + ByteUtil.LINE.length;
            String dispostionStr = new String(dispostion);
            if (dispostionStr == null || dispostionStr.trim().length() == 0) {
                return;
            }
            if (new String(type).indexOf(TYPE) == 0) {
                byte[] non = ByteUtil.getLineCrLf(buffer, pos);
                data = ByteUtil.copyByteData(buffer, pos += non.length + ByteUtil.LINE.length, buffer.length - pos);
                data = MultiHttpGeneralForm.getFormData(data, header);
                pos += data.length + 1;
                String key = this.getKey(dispostionStr);
                key = URLDecodeUtil.filter(key);
                String fileName = this.getFileName(dispostionStr);
                if (fileName == null || fileName.length() == 0) continue;
                UploadFile file = new UploadFile();
                try {
                    file.setData(data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                file.setFileName(fileName);
                file.setSize(data.length);
                this.addParameter(key, (Object)file);
                continue;
            }
            data = ByteUtil.getLineCrLf(buffer, pos);
            pos += data.length + ByteUtil.LINE.length;
            String key = this.getKey(new String(dispostion));
            key = URLDecodeUtil.filter(key);
            String dataStr = URLDecodeUtil.filter(new String(data));
            this.addParameter(key, (Object)dataStr);
        }
    }

    protected static byte[] getFormData(byte[] buffer, byte[] header) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        int endPos = ByteUtil.indexof(buffer, header);
        byte[] byteArray = ByteUtil.copyByteData(buffer, 0, endPos);
        return byteArray;
    }

    private String getFileName(String disposition) {
        int idx = disposition.lastIndexOf(System.getProperty("file.separator"));
        if (idx == -1) {
            idx = disposition.lastIndexOf("filename=");
            idx += "filename=".length();
        }
        String fileName = disposition.substring(idx + 1, disposition.length() - 1);
        return fileName;
    }

    private String getKey(String disposition) {
        int start = disposition.indexOf("name=\"");
        String stack = disposition.substring(start + "name=\"".length(), disposition.length());
        int end = stack.indexOf("\"");
        String key = stack.substring(0, end);
        return key;
    }
}

