/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.itscool.commons.collection.KeyLinkedList;
import org.itscool.commons.document.XmlConfigExceptionHandler;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.util.URLDecodeUtil;
import org.itscool.commons.util.UrlUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class XmlConfigReader {
    protected AbstractLog log = SimpleLog.getInstance();
    protected File xmlFile;
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    protected Document document;
    protected String configName;

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void create(HashMap nodeList) throws IOException {
        this.configName = URLDecodeUtil.decode(this.configName, "utf8");
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL url = parent.getResource(this.configName);
        if (url == null) {
            throw new IOException(this.configName + " is not found.");
        }
        this.log.info("load config is " + url.getFile());
        this.create(url.getFile(), nodeList);
    }

    public void create(LinkedList nodeList) throws IOException {
        this.configName = URLDecodeUtil.decode(this.configName, "utf8");
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL url = parent.getResource(this.configName);
        if (url == null) {
            throw new IOException(this.configName + " is not found.");
        }
        String fileStr = url.getFile();
        String pathStr = url.getPath();
        fileStr = URLDecodeUtil.decode(fileStr, "utf8");
        pathStr = URLDecodeUtil.decode(pathStr, "utf8");
        this.log.info("load config is " + fileStr);
        this.create(pathStr, nodeList);
    }

    public void create(KeyLinkedList nodeList) throws IOException {
        this.configName = URLDecodeUtil.decode(this.configName, "utf8");
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL url = parent.getResource(this.configName);
        if (url == null) {
            throw new IOException(this.configName + " is not found.");
        }
        String fileStr = url.getFile();
        String pathStr = url.getPath();
        fileStr = URLDecodeUtil.decode(fileStr, "utf8");
        pathStr = URLDecodeUtil.decode(pathStr, "utf8");
        this.log.info("load config is " + fileStr);
        this.create(pathStr, nodeList);
    }

    public void create(String path, HashMap nodeList) throws IOException {
        path = UrlUtil.replacePath(path);
        File xmlFile = new File(path = URLDecodeUtil.decode(path, "utf8"));
        if (!xmlFile.isFile()) {
            String err = "Can not found file at config file(" + path + ")";
            throw new IOException(err);
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(path);
            this.builder.setErrorHandler(handler);
            this.document = this.builder.parse(xmlFile);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    public void create(String path, LinkedList nodeList) throws IOException {
        path = UrlUtil.replacePath(path);
        File xmlFile = new File(path = URLDecodeUtil.decode(path, "utf8"));
        if (!xmlFile.isFile()) {
            String err = "[" + path + "]" + "Can not found file  at config file(" + XmlConfigReader.class.getName() + ")";
            throw new IOException(err);
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
            this.builder = this.factory.newDocumentBuilder();
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(path);
            this.builder.setErrorHandler(handler);
            this.document = this.builder.parse(xmlFile);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    public void create(String path, KeyLinkedList nodeList) throws IOException {
        path = UrlUtil.replacePath(path);
        File xmlFile = new File(path = URLDecodeUtil.decode(path, "utf8"));
        if (!xmlFile.isFile()) {
            String err = "[" + path + "]" + "Can not found file  at config file(" + XmlConfigReader.class.getName() + ")";
            throw new IOException(err);
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
            this.builder = this.factory.newDocumentBuilder();
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(path);
            this.builder.setErrorHandler(handler);
            this.document = this.builder.parse(xmlFile);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    public void create(String uri, byte[] buf, HashMap nodeList) throws IOException {
        try {
            uri = URLDecodeUtil.decode(uri, "utf8");
            ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(uri);
            this.builder.setErrorHandler(handler);
            this.document = this.builder.parse(bIn);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.doCreate(nodeList);
    }

    public void create(String uri, byte[] buf, LinkedList nodeList) throws IOException {
        try {
            uri = URLDecodeUtil.decode(uri, "utf8");
            ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(uri);
            this.builder.setErrorHandler(handler);
            this.document = this.builder.parse(bIn);
        }
        catch (SAXException e) {
            String msg = e.getMessage() + System.getProperty("line.separator") + new String(buf);
            throw new IOException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage() + System.getProperty("line.separator") + new String(buf);
            throw new IOException(msg);
        }
        this.doCreate(nodeList);
    }

    protected void doCreate(HashMap nodeList) throws IOException {
    }

    protected void doCreate(LinkedList nodeList) throws IOException {
    }

    protected void doCreate(KeyLinkedList nodeList) throws IOException {
    }
}

