//This File encoding is utf-8

/**
 * XMLHttpObjectを取得します
 * @param cbFunc onreadystatechangeにセットするコールバック関数を指定します
 * @return XMLHttpObjectを返します
*/
function createXMLHttpRequest(cbFunc)
{
    var XMLhttpObject = getHttpObject();
    if (XMLhttpObject){
        XMLhttpObject.onreadystatechange = cbFunc;
    }
    return XMLhttpObject;
}

/**
 * XMLHttpObjectを取得します
 * @return XMLHttpObjectを返します
*/
function getHttpObject() {
    var XMLhttpObject = null;
    try{
        XMLhttpObject = new XMLHttpRequest();
    }catch(e){
        try{
            XMLhttpObject = new ActiveXObject("Msxml2.XMLHTTP");
        }catch(e){
            try{
                XMLhttpObject = new ActiveXObject("Microsoft.XMLHTTP");
            }catch(e){
                return null;
            }
        }
    }
    return XMLhttpObject;
}

/**
 * イベントリスナー用ラッパ関数
 * 外部（HTML)からaddListenerで呼び出され、内部でIEとそのほかのブラウザ
 * で処理関数を切り替えて処理しています。
 * @param obj イベントタイプ
 * @param イベントが発生したときに呼び出されるコールバック関数
 * @param trueを指定するとキャプチャーフレーズ/falseを指定するとバブリングレーズ
 * @reurn 処理にしっぱした場合はfalseを返します。
*/
function addListener(obj, eventType, func, cap){
    if(obj.attachEvent){    //IEの場合
        obj.attachEvent('on' + eventType, func);
    }else if(obj.addEventListener){    //そのほかのブラウザ
        obj.addEventListener(eventType, func, cap);
    }else {
        alert('No support on your Browser');
        return false;
    }
}
