package org.itscool.weber.user;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanFactory;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.util.AngouUtil;
import org.itscool.commons.util.StringUtil;

/**
 * [UF؂ǗNXł<br>
 * ̃NXorg.itscool.weber.user.RoleFileManagerNX̃f[^x[Xłł<br>
 *
 * <p>
 * RoleDbManagerNX́A[UƃpX[h`e[u
 * pӂ邱ƂŁAAvP[VŃ[UF؂sƂł܂<br>
 * </p>
 *
 * <p>
 * Webert[[Nł́Aorg.itscool.weber.aciton.ActionNXisUserCheck()
 * \bhŗpĂ܂B<br/>
 * FrontServletActionĂ΂ꂽꍇAActionsOActionv
 * [UActions錠邩fĂ܂<br/>
 * </p>
 *
 * <p>
 * Webert[[NŃf[^x[Xɂ郆[UF؋@\Lɂ邽߂ɂ́A
 * di-config.xmlt@CɈȉ̏RoleDbManagero^Kv܂<br/>
 * </p>
 *
 * <pre>
 * &lt;bean id="WeberUserManager" type="org.itscool.weber.user.RoleDbManager" singleton="true"/&gt;
 * </pre>
 * <br/>
 *
 * <p>
 * ÃNX̓RlNV̎擾org.itscool.commons.TransactionUtilNX
 * gpĂ܂B<br/>
 * TransactionUtilʂɍ쐬邱Ƃ\łAorg.itscool.commons.ConnectionManager
 * NX𗘗p΁A̎ԂȂƂł܂B<br/>
 * </p>
 *
 * <p>
 * ConnectionManager̓o^di-config.xmlōs܂B<br/>
 * JDBCDataSourcêǂ𗘗p邩Őݒeς܂B
 * </p>
 *
 * <p>ȉ́AJDBC𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.OriginalConnectionManager" singleton="true"&gt;
 *   &lt;property name="url" value="jdbc:hsqldb:hsql://localhost"/&gt;
 *   &lt;property name="user" value="sa"/&gt;
 *   &lt;property name="pwd" value=""/&gt;
 *   &lt;property name="drvname" value="org.hsqldb.jdbcDriver"/&gt;
 *   &lt;property name="timeout" value="300"/&gt;
 *   &lt;property name="initSize" value="3"/&gt;
 *   &lt;property name="maxSize" value="10"/&gt;
 *   &lt;property name="mode" value="false"/&gt;
 *   &lt;property name="showSql" value="false"/&gt;
 * &lt;/bean&gt;
 * </pre><br/>
 *
 * <p>ȉ́ADataSource𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.DataSourceManager" singleton="true"&gt;
 *   &lt;property name="dsName" value="java:comp/env/weber-jndi"/&gt;
 *   &lt;property name="mode" value="false"/&gt;
 *   &lt;property name="showSql" value="true"/&gt;
 * &lt;/bean&gt;
 * </pre>
 *
 * <p>ConnectionManagerC^[tF[Xitscool-commons.jarɊ܂܂Ă܂</p>
 *
 * <p>
 * [Uf[^x[XŊǗ邽߂ɂ́A炩߈ȉ̃e[u
 * Kv܂<br>
 * </p>
 * <p>
 * (1) e[uiWEBER_ROLE)
 * <table border="1">
 * <tr>
 * 		<td>tB[h</td>
 * 		<td>^</td>
 * 		<td>l</td>
 * 		<td>K{</td>
 * 		<td>TCY</td>
 * 		<td>L[</td>
 * 		<td>Qƃe[u</td>
 * 		<td>QƃL[</td>
 * </tr>
 * <tr>
 * 		<td>ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>NAME</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * </table>
 * </p><br/>
 *
 * <p>
 * (2) [Ue[uiWEBER_USER)
 * <table border="1">
 * <tr>
 * 		<td>tB[h</td>
 * 		<td>^</td>
 * 		<td>l</td>
 * 		<td>K{</td>
 * 		<td>TCY</td>
 * 		<td>L[</td>
 * 		<td>Qƃe[u</td>
 * 		<td>QƃL[</td>
 * </tr>
 * <tr>
 * 		<td>ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>NAME</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>PASSWORD</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>ROLE_ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td></td>
 * 		<td>WEBER_ROLE</td>
 * 		<td>ID</td>
 * </tr>
 * </table>
 * </p><br/>
 *
 * <p>
 * e[uɂWebAvP[Vŗp\ȃ[`܂<br/>
 * [Ue[uɂWebAvP[Vŗp\ȃ[UƃpX[h
 * `܂B<br>
 * </p>
 * <p>
 * org.itscool.weber.user.CreateUserForDbNX𗘗p΁ApX[hÍ
 * [U쐬邱Ƃł܂<br>
 * ڂ<a href="./CreateUserForDb.html">org.itscool.weber.user.CreateUserForDbNX̐</a>QƂĂ<br>
 * </p>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/9/8
 */
public class UserEntityManager implements UserManager{
    private AbstractLog log;
    private boolean initFlg = false;
    
    /** BWeberUserManagerCX^X */
    private static UserEntityManager instance = null;
    
    /**
     * WeberUserManagerCX^X擾܂
     * @return RoleMangerCX^Xԋp܂
     */
    public static UserEntityManager getInstance(){
        if( instance == null ){
            instance = new UserEntityManager();
        }
        return instance;
    }
    
    /** vCx[gȃRXgN^ */
    private UserEntityManager(){
        BeanFactory factory = BeanFactory.getInstance();
        try{
            log = (AbstractLog)factory.getInstance("Log");
            if(!log.isInit()){
                log = (AbstractLog)factory.createInstance("Log");
            }
            initFlg = true;
        }catch(Exception ioe){
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
    }
    
    public boolean isInit(){
        return initFlg;
    }
    
    public void init(){
//        initFlg = true;
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param roles 
     * @param user [U
     * @return ̃[UɂANZXĂꍇtrueԂ܂
     */
    public boolean isUserCheck(HashMap roles, User user ) {
        if( user == null ){
            return false;
        }
        if( roles == null || roles.size() == 0 ){
            return isRoles(user);
        }else{
            return isRoles(roles, user);
        }
    }
    
    /**
     * [UF؂s܂
     * @param roles t@C̃Xg
     * @param user [U
     * @return ̃[UÓłtrueԂ܂
     */
    private boolean isRoles(HashMap roles, User user ) {
        boolean ret = false;
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        
        UserDao dao = new UserDao();
        while( it.hasNext() ){
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            String userName = user.getName();
            User dbUser = dao.getUser(roleName, userName);
            ret = isRole(user, dbUser);
            if( ret ){
                //Zbg
                user.setRole(dbUser.getRole());
                return ret;
            }
        }
        return ret;
    }
    
    /**
     * [UF؂s܂<BR>
     * RoleFileManagerɓo^ĂSĂ̌񂩂Y
     * [U݂邩ׂ܂B
     * @param user [U
     * @return ̃[UÓłtrueԂ܂
     */
    private boolean isRoles(User user ){
        boolean ret = false;
        UserDao dao = new UserDao();
        List users = dao.getUsers(user.getName());
        
        for(int i=0; i<users.size(); i++){
            User dbUser = (User)users.get(i);
            ret = isRole(user, dbUser);
            if( ret ){
                //Zbg
                Role userRole = dbUser.getRole();
                user.setRole(userRole);
                return ret;
            }
        }
        return ret;
    }
    
    /**
     * w肳ꂽ[UANZXĂ邩肵܂<BR>
     * ÍꂽpX[hAngouNXɂĕ܂
     * @param User [U
     * @param roleFile [hꂽt@C
     * @return ̃[UɂANZXĂꍇtrueԂ܂
     */
    private boolean isRole(User loginUser, User dbUser){
        
        if( dbUser == null ) return false;
        if( loginUser == null ) return false;
        if( !dbUser.getName().equals(loginUser.getName())) return false;
        
        //pX[h̕
        String pwd = "";
        try{
            byte[] pwdBytes = StringUtil.decodeHex(dbUser.getPwd(), "ISO-8859-1");
            if(pwdBytes!=null){
                pwd = AngouUtil.decrypt(dbUser.getName(), pwdBytes );
            }else{
                log.warn("passward decode hex is missing. user["+dbUser.getName()+"] is non decode hex.");
                pwd = dbUser.getPwd();
            }
        }catch(IOException ioe){
            throw new RuntimeException(ioe.getMessage());
        }
        if( pwd == null ){
            if(loginUser.getPwd() == null || loginUser.getPwd().length()==0){
                return true;
            }else{
                return false;
            }
        }
        if( !pwd.equals(loginUser.getPwd())) return false;
        
        //[UID̈p
        loginUser.setId(dbUser.getId());
        
        return true;
        
    }
    /**
     * pX[ht@C̍ēǂݍ݂s܂B
     */
    public void reload() {
        //non process
    }
    
    public List getAllData(){
        UserDao userDao = new UserDao();
        List users = userDao.getAllData();
        for(int i=0; i<users.size(); i++){
            User user = (User)users.get(i);
            //pX[h̕
            if( user != null ){
                String pwd = "";
                try{
                    byte[] pwdBytes = StringUtil.decodeHex(user.getPwd(), "ISO-8859-1");
                    pwd = AngouUtil.decrypt(user.getName(), pwdBytes );
                }catch(IOException ioe){
                    throw new RuntimeException(ioe.getMessage());
                }
                user.setPwd(pwd);
            }
        }
        return users;
    }
    
    /**
     * w肳ꂽ[UɊÂ[U擾܂
     * @param roleName [
     * @param userName [U
     * @return [UԂ܂
     */
    public User getUser(String roleName, String userName){
        RoleDao dao = new RoleDao();
        Role role = dao.getRole(roleName);
        if( role != null ){
            UserDao userDao = new UserDao();
            User user = userDao.getUser(role, userName);
            //pX[h̕
            if( user != null ){
                try{
                    String pwd = decrypt(user.getName(), user.getPwd());
                    user.setPwd(pwd);
                }catch(IOException ioe){
                    log.warn("passward decode hex is missing. user["+user.getName()+"] is non decode hex.");
                }
            }
            return user;
        }
        return null;
    }
    
    /**
     * Íꂽ[UpX[h𕜌܂
     * @param userName [U
     * @param srcPwd ÍꂽpX[h
     * @return ꂽpX[h
     */
    public static String decrypt(String userName, String srcPwd)
    throws IOException{
        byte[] pwdBytes = StringUtil.decodeHex(srcPwd, "ISO-8859-1");
        String dstPwd = AngouUtil.decrypt(userName, pwdBytes );
        return dstPwd;
    }
    
    /**
     * [UpX[hÍ܂
     * @param userName [U
     * @param srcPwd [UpX[h
     * @return ÍꂽpX[h
     */
    public static String encrypt(String userName, String srcPwd)
    throws IOException{
        //pX[hÍ
        byte[] pwdAngou = AngouUtil.encrypt(userName, srcPwd);
        String pwdAngouStr = StringUtil.encodeHex(pwdAngou, "ISO-8859-1");
        return pwdAngouStr;
    }
    /**
     * w肳ꂽ[ŨXg擾܂
     * @param roleName [
     * @return [ŨXg
     */
    public HashMap getUsers(String roleName){
        HashMap users = new HashMap();
        RoleDao roleDao = new RoleDao();
        Role role = roleDao.getRole(roleName);
        UserDao dao = new UserDao();
        List lst = dao.getUsers(role);
        for(int i=0; i<lst.size(); i++){
            User user = (User)lst.get(i);
            try{
                String pwd = decrypt(user.getName(), user.getPwd());
                user.setPwd(pwd);
            }catch(IOException ioe){
                log.warn("passward decode hex is missing. user["+user.getName()+"] is non decode hex.");
            }
            users.put(user.getName(), user);
        }
        return users;
    }
    /**
     * w肳ꂽ[U폜܂
     * @param user [U
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public void delete(User user) throws IOException{
        UserDao dao = new UserDao();
        dao.delete(user);
    }
    
    /**
     * w肳ꂽ[U폜܂
     * @param roleName [
     * @param user [U
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public void delete(String roleName, User user) throws IOException{
        UserDao dao = new UserDao();
        if(user.getRoleId() == -1){
            RoleDao roleDao = new RoleDao();
            Role role = roleDao.getRole(roleName);
            user.setRoleId(role.getId());
        }
        dao.delete(user);
    }
    
    /**
     * w肳ꂽ[U폜܂
     * @param roleName [
     * @param name [U
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public void delete(String roleName, String name) throws IOException{
        User user = new User();
        user.setName(name);
        delete(roleName, user);
    }
    /**
     * w肳ꂽ[Uǉ܂<BR>
     * [U̒ǉɐꍇUser.idIDlZbg܂B
     * @param user [U
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public boolean add(User user) throws IOException{
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());

        //pX[hÍ
        String pwdAngouStr = encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);

        int id = dao.save(newUser);
        //IDZbg
        user.setId(id);
        
        return true;
    }
    
    /**
     * w肳ꂽ[Uǉ܂<BR>
     * [U̒ǉɐꍇUser.idIDlZbg܂B
     * @param roleName [
     * @param user [U
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public boolean add(String roleName, User user) throws IOException{
        if(user.getRoleId() == -1){
            RoleDao dao = new RoleDao();
            Role role = dao.getRole(roleName);
            if( role == null ){
                return false;
            }
            user.setRoleId(role.getId());
        }
        UserDao dao = new UserDao();
        if( getUser(roleName, user.getName()) == null ){
            User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());
            
            //pX[hÍ
            String pwdAngouStr = encrypt(user.getName(), user.getPwd());
            newUser.setPwd(pwdAngouStr);
            
            int id = dao.save(newUser);
            //IDZbg
            user.setId(id);
            return true;
        }else{
            return false;
        }
    }
    
    /**
     * w肳ꂽ[Uǉ܂
     * @param roleName [
     * @param name [U
     * @param pwd pX[h
     * @return ǉɐꍇtrueԂ܂B
     * ɓo^ς݂̏ꍇfalseԂ܂
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public boolean add(String roleName, String name, String pwd) throws IOException{
        User user = new User();
        user.setName(name);
        user.setPwd(pwd);
        return add(roleName, user);
    }
    /**
     * w肳ꂽ[UXV܂
     * @param user [U
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public void update(User user) throws IOException{
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());
        String pwdAngouStr = encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);
        
        dao.update(newUser);
    }
    
    /**
     * w肳ꂽ[UXV܂
     * @param roleName [
     * @param user [U
     * @deprecated [UAvP[V炱̃\bh͎gpȂŉ
     * @throws IOException
     */
    public void update(String roleName, User user) throws IOException{
        RoleDao roleDao = new RoleDao();
        Role role = roleDao.getRole(roleName);
        user.setId(role.getId());
        
        UserDao dao = new UserDao();
        User newUser = (User)BeanUtil.copyInstance(user, User.class.getName());
        String pwdAngouStr = encrypt(user.getName(), user.getPwd());
        newUser.setPwd(pwdAngouStr);
        
        dao.update(newUser);
        
    }
    
    public boolean addRole(Role role){
        RoleDao roleDao = new RoleDao();
        
        if( roleDao.getRole(role.getName()) != null ){
            return false;
        }
        
        roleDao.save(role);
        
        return true;
    }
    
    public boolean deleteRole(Role role){
        RoleDao roleDao = new RoleDao();
        UserDao userDao = new UserDao();
        
        if( userDao.getUsers(role).size() > 0 ){
            return false;
        }
        
        roleDao.delete(role);
        
        return true;
    }
    
    
}
