package org.itscool.weber.io;

import java.io.IOException;
import java.util.LinkedList;

import org.itscool.commons.document.XmlConfigReader;
import org.itscool.weber.mapping.ExceptionMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * weber-config.xml&lt;global-exceptions&gt;vf͂NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class ExceptionConfigReader extends XmlConfigReader{
    
    /**
     * XMLt@C&lt;exceptions&gt;vf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param hashMap XML̉͌
    */
    protected void doCreate(LinkedList hashMap) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at itscool-config.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        /* action-mappings ̎擾*/
        NodeList exceptionList = root.getElementsByTagName("global-exceptions");
        if( exceptionList != null ){
            Node exception = exceptionList.item(0);
            if( exception != null ){
                createExceptions(exception, hashMap);
            }
        }
    }
    
    /**
     * &lt;exception&gt;vf͂܂
     * @param exceptions &lt;exceptions&gt;vf
     * @param hashMap ͌&lt;exceptions&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createExceptions(Node exceptions, LinkedList hashMap){
        NodeList exceptionsChilds = exceptions.getChildNodes();
        
        for( int i = 0; i < exceptionsChilds.getLength(); i++) {
            Node exception = exceptionsChilds.item(i);
            if( exception.getNodeName().equals("exception")){
                createException(exception, hashMap);
            }
        }
    }
    
    /**
     * &lt;exception&gt;vf̑͂܂
     * @param exception &lt;exception&gt;vf
     * @param hashMap ͌&lt;exception&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createException(Node exception, LinkedList hashMap){
        NamedNodeMap attributes = exception.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        
        if( path == null || name == null ){
        	return;
        }
        ExceptionMapping mapping = new ExceptionMapping(
            path.getNodeValue(), name.getNodeValue());
        hashMap.addFirst( mapping );
        
    }
}
