package org.itscool.stylist.tag;

import java.util.ArrayList;
import java.util.LinkedList;

/**
 * HTML̃^OǗNX
 * @version 1.00A 2006/04/11 kano
 */
public class HtmlTag extends LinkedList{
    public static final String TEXT="#text";
    public static final String COMMENT="#comment";
    public static final String TAG_TEXTAREA="textarea";
    public static final String TAG_SELECT="select";
    public static final String TAG_HTML="html";
    public static final String TAG_HEAD="head";
    public static final String TAG_TITLE="title";
    public static final String TAG_SCRIPT="script";
    public static final String TAG_STYLE="style";
    public static final String TAG_BODY="body";
    
    public static final String KIND_TAG = "tag";
    public static final String KIND_SIMPLE_TAG = "simple";
    public static final String KIND_COMMENT = "comment";
    public static final String KIND_TEXT = "text";
    public static final String KIND_ITERATE = "iterate";
    public static final String KIND_EQUAL = "equal";
    public static final String KIND_NOTEQUAL = "neq";
    public static final String KIND_MOREEQUAL = "meq";
    public static final String KIND_LESSEQUAL = "leq";
    public static final String KIND_MORETHAN = "mthan";
    public static final String KIND_LESSTHAN = "lthan";
    public static final String KIND_MATCH = "match";
    public static final String KIND_NOMATCH = "nmatch";
    public static final String KIND_ISNULL = "isnull";
    public static final String KIND_ISNOTNULL = "isnotnull";
    public static final String KIND_WRITE = "write";
    public static final String KIND_DISPLAY_ERROR = "error";
    public static final String KIND_INCLUDE = "include";
    public static final String KIND_CDATA="cdata";
    
    /**
     * e^O
     */
    protected HtmlTag   parent;
    
    /**
     * Xg
     */
    protected ArrayList attributeList = new ArrayList();
    
    /**
     * ^O
     */
    protected String tagName;
    
    /**
     * ^O
     */
    protected String tagKind;
    
    /**
     * HTML̃m[hString`Ŏ擾܂
     * @param floor m[h̊Kw
     * @param tab KwTAB
     * @return HTML̃m[h
     */
    public String toString(int floor, String tab){
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        
        sb.append(floor + " : ");
        if(tagKind.equals(KIND_TAG)){
            sb.append("[B_TAG]   |");
        }else if( tagKind.equals(KIND_SIMPLE_TAG)){
            sb.append("[S_TAG]   |");
        }else if( tagKind.equals(KIND_COMMENT)){
            sb.append("[COMMENT] |");
        }else if( tagKind.equals(KIND_ITERATE)){
            sb.append("[ITERATE] |");
        }else if( tagKind.equals(KIND_EQUAL)){
            sb.append("[EQUAL]   |");
        }else if( tagKind.equals(KIND_MOREEQUAL)){
            sb.append("[MORE_EQ] |");
        }else if( tagKind.equals(KIND_LESSEQUAL)){
            sb.append("[LESS_EQ] |");
        }else if( tagKind.equals(KIND_MORETHAN)){
            sb.append("[M_THAN]  |");
        }else if( tagKind.equals(KIND_LESSTHAN)){
            sb.append("[L_THAN]  |");
        }else if( tagKind.equals(KIND_ISNULL)){
            sb.append("[ISNULL]  |");
        }else if( tagKind.equals(KIND_ISNOTNULL)){
            sb.append("[ISNOTNULL]|");
        }else if( tagKind.equals(KIND_TEXT)){
            sb.append("[TEXT]    |");
        }else if( tagKind.equals(KIND_WRITE)){
            sb.append("[WRITE]   |");
        }else if( tagKind.equals(KIND_DISPLAY_ERROR)){
            sb.append("[ERROR]   |");
        }else if( tagKind.equals(KIND_INCLUDE)){
            sb.append("[INCLUDE] |");
        }else if( tagKind.equals(KIND_CDATA)){
            sb.append("[CDATA]   |");
        }else{
            sb.append("[FAITAL]  |");
        }
        sb.append(tab).append(tagName);
        int attrSize = attributeList.size();
        if( attrSize > 0){
            sb.append(" ( ");
        }
        for( int i=0; i<attrSize; i++ ){
            HtmlAttribute attr = (HtmlAttribute)attributeList.get(i);
            sb.append(attr.getName());
            sb.append("=");
            sb.append(attr.getValue());
            sb.append(" ");
            
        }
        if( attrSize > 0){
            sb.append(")");
        }
        sb.append(line);
        int nodeSize = this.size();
        for( int i=0; i<nodeSize; i++){
            HtmlTag child = (HtmlTag)this.get(i);
            sb.append(child.toString(floor+1, tab+"  "));
        }
        return sb.toString();
    }
    
    /**
     * m[hɎqm[hǉ܂
     * @param node qm[h
     */
    public void addHtmlNode(HtmlTag node){
        this.add(node);
    }
    
    /**
     * m[hɃ^Ȏǉ܂
     * @param attr ^Ȏ
     */
    public void addAttribute(HtmlAttribute attr){
        attributeList.add(attr);
    }
    
    /**
     * ̈ꗗ擾܂
     * @return ArrayList ̈ꗗ
     */
    public ArrayList getAttributeList() {
        return attributeList;
    }
    
    /**
     * ̈ꗗZbg܂
     * @param attributeList ̈ꗗ
     */
    public void setAttributeList(ArrayList attributeList) {
        this.attributeList = attributeList;
    }
    
    /**
     * ^Oʂ擾܂
     * @return String ^O
     */
    public String getTagKind() {
        return tagKind;
    }
    
    /**
     * ^Oʂݒ肵܂
     * @param tagKind ^O
     */
    public void setTagKind(String tagKind) {
        this.tagKind = tagKind;
    }
    
    /**
     * ^Ô擾܂
     * @return String ^O
     */
    public String getTagName() {
        return tagName;
    }
    
    /**
     * ^Ôݒ肵܂
     * @param tagName ^O
     */
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }
    
    /**
     * w肳ꂽȎl𕶎Ŏ擾܂
     * @param name ̖O
     * @return ̒l
     */
    public String getAttribute(String name){
        int size = attributeList.size();
        for(int i=0; i<size; i++){
            HtmlAttribute attr = (HtmlAttribute)attributeList.get(i);
            if(attr.getName().equals(name)){
                return attr.getValue();
            }
        }
        return null;
    }
    
    /**
     * w肳ꂽȎl𕶎Ŏ擾܂
     * @param name ̖O
     * @return ̒l
     */
    public HtmlAttribute getHtmlAttribute(String name){
        int size = attributeList.size();
        for(int i=0; i<size; i++){
            HtmlAttribute attr = (HtmlAttribute)attributeList.get(i);
            if(attr.getName().equals(name)){
                return attr;
            }
        }
        return null;
    }
    
    /**
     * e^O擾܂
     * @return e^O
     */
    public HtmlTag getParent() {
        return parent;
    }
    
    /**
     * e^OZbg܂
     * @param parent e^O
     */
    public void setParent(HtmlTag parent) {
        this.parent = parent;
    }
    
}