package org.itscool.stylist.io;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.ServletTagUtil;
import org.itscool.stylist.tag.HtmlAttribute;
import org.itscool.stylist.tag.HtmlTag;

/**
 * XHTMLɊ܂܂JԂ^Of[^ɕϊ܂
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlIterateTagConverter extends HtmlConverter {
//    /**
//     * CX^X̏s܂
//     * @param context ServletContextCX^X
//     * @param req HttpServletRequestCX^X
//     */
//    public HtmlIterateTagConverter(ServletContext context,
//        HttpServletRequest req) {
//        super(context, req);
//    }
    
    /**
     * pXHTMLf[^̍쐬Jn܂
     * @param node HtmlTagCX^X
     * @return f[^
     */
    public String convert(HtmlTag node, String tab) {
        String tagName = node.getTagName();
        StringBuffer sb = new StringBuffer();
        Iterator iterator = null;
        String id = node.getAttribute(HtmlAttribute.W_ID);
        String name = node.getAttribute(HtmlAttribute.W_NAME);
        String property = node.getAttribute(HtmlAttribute.W_PROPERTY);
        String scope = node.getAttribute(HtmlAttribute.W_SCOPE);
        
        Object collection =
            ServletTagUtil.findObject(context, req, name, scope);
        if( property != null ){
            collection = BeanUtil.getProperty(collection, property);
        }
        
        //zvfnull̏ꍇ͗vf0̉̔zCX^X쐬܂
        if( collection == null ){
            collection = new LinkedList();
        }
        
        //z\^肵܂B
        if (collection.getClass().isArray()) {
            try {
                iterator = Arrays.asList((Object[]) collection).iterator();
            } catch (ClassCastException e) {
                // Rats -- it is an array of primitives
                int length = Array.getLength(collection);
                ArrayList c = new ArrayList(length);
                for (int i = 0; i < length; i++) {
                    c.add(Array.get(collection, i));
                }
                iterator = c.iterator();
            }
        } else if (collection instanceof Collection) {
            iterator = ((Collection) collection).iterator();
        } else if (collection instanceof Iterator) {
            iterator = (Iterator) collection;
        } else if (collection instanceof Map) {
            iterator = ((Map) collection).entrySet().iterator();
        } else if (collection instanceof Enumeration) {
            //    iterator = IteratorUtils.asIterator((Enumeration) collection);
        } else {
            return "";
        }
        if( iterator == null ){
            return "";
        }
        while(iterator.hasNext()){
            //zvfNGXgXR[vŃZbg
            Object obj = iterator.next();
            req.setAttribute(id, obj);
            
            //zvfqHtmlNode]
            int size = node.size();
            for(int i=0; i<size; i++ ){
                HtmlTag child = (HtmlTag)node.get(i);
                sb.append(super.convert(child, tab + "  "));
            }
        }
        return sb.toString();
    }
    
}
