/*
 * 쐬: 2005/05/29
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

/**
 * HttpServletRequestɃZbgĂ郊NGXgp[^͂A
 * GeneralFormNXɕϊ܂
 * @author KANO
 */
public class GeneralFormFactory {
    private static GeneralFormFactory factory = null;
    protected static AbstractLog log;
    
    private GeneralFormFactory(){
        BeanFactory factory = BeanFactory.getInstance();
        try{
            log = (AbstractLog)factory.getInstance("Log");
            if(!log.isInit()){
                log = (AbstractLog)factory.createInstance("Log");
            }
        }catch(Exception ioe){
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
    }
    
    /**
     * P̃t@NgNX擾܂
     * @return t@NgNXԂ܂
     */
    public static GeneralFormFactory getInstance(){
        if(factory == null){
            factory = new GeneralFormFactory();
        }
        return factory;
    }
    
    /**
     * AbstractPostRequestCX^X𐶐܂
     * @param req HttpServletRequestCX^X
     * @param encode GR[fBO
     * @return AbstractPostRequestCX^XԂ܂
     * @throws IOException
     */
    public GeneralForm create(HttpServletRequest req, String encode) throws IOException{
        HttpGeneralForm generalForm = null;
        //t@CAbv[h܂܂Ă邩
        String type = req.getHeader("content-type");
//        Enumeration headerNames = req.getHeaderNames();
//        while( headerNames.hasMoreElements() ){
//            String headerName = (String) headerNames.nextElement();
//            String headerValue = req.getHeader(headerName);
//            System.out.println(headerName + ":" + headerValue);
//        }
        //t@CAbv[h܂܂Ăꍇ
        if(type != null && type.toLowerCase().indexOf("multipart") != -1 ){
            generalForm = new MultiHttpGeneralForm();
            parseData(generalForm, req, encode);
        }else{
            generalForm = new SimpleHttpGeneralForm();
            //debug start 2005/10/25 kano
            //postReq.doDefaultParseData(req);
            parseData(generalForm, req, encode);
            //debug end 2005/10/25 kano
        }
//        postReq.parseData(req);
        return generalForm;
    }
    
//add 2006/12/08 kano start
    /**
     * HttpServletRequestCX^X̎M
     * @param req HttpServletRequestCX^X
     * @throws IOException
     */
    public void parseData(HttpGeneralForm generalForm, HttpServletRequest req, String encode) throws IOException {
        //System.out.println("MMMEEEETTTTHHHHOOOODDD:"+req.getMethod());
        String methodType = req.getMethod();
        log.trace("mothod type=" + methodType);
        try {
            req.setCharacterEncoding(encode);
        } catch (java.io.UnsupportedEncodingException uee) {
            throw new IOException(uee);
        }
        if(methodType.equals("POST") ){
            
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(req.getInputStream());

            boolean flag=true;
            while(flag) {
                try {
                    byte b=dis.readByte();
                    bao.write(b);
                } catch(EOFException e){
                    flag=false;
                }
            }
            if(bao.size() > 0){
                generalForm.doParseData(bao.toByteArray(), encode);
            }else{
                generalForm.doDefaultParseData(req, encode);
            }
        }else{
            generalForm.doDefaultParseData(req, encode);
        }
        
//        boolean flag=true;
//        while(flag) {
//            try {
//                byte b=dis.readByte();
//                bao.write(b);
//            } catch(EOFException e){
//                flag=false;
//            }
//        }
//        //formANVɂmethodw肳ĂȂꍇInputStream擾
//        //łȂۂ̑Ή
//        if( bao.size() == 0 ){
//            generalForm.doDefaultParseData(req, encode);
//        }else{
//            generalForm.doParseData(bao.toByteArray(), encode);
//        }
    }
//add 2006/12/08 kano end
}
