/*
 * BaseElRegexTest.java
 *
 * Created on 2007/03/19, 14:10
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.stylist.el;

import junit.framework.TestCase;
import org.itscool.stylist.el.BaseElRegex;

public class BaseElRegex2Test extends TestCase{
    public void testParseFunction(){
        BaseElRegex regex = new BaseElRegex();
        String el = "mathC.add(1, 2)";
        String result = regex.parseFunction(el);
        assertEquals(el,"3", result);
    }
    
    public void testParseFunction2(){
        BaseElRegex regex = new BaseElRegex();
        String result = regex.parseFunction("${dateC.format('Sun Mar 11 00:00:00 JST 2007' , 'yyyy/MM/dd')}");
        assertEquals("result", "2007/03/11", result); 
    }
    
    public void testParseFunction3(){
        BaseElRegex regex = new BaseElRegex();
        String result = regex.parseFunction("${dateC.format(\"Sun Mar 11 00:00:00 JST 2007\" , 'yyyy/MM/dd')}");
        assertEquals("result", "2007/03/11", result); 
    }
    
    public void testReplaceFunction(){
        BaseElRegex regex = new BaseElRegex();
        String result = regex.replaceFunction(null, "1 + 2 = ${mathC.add(1, 2)} !");
        assertEquals("result", "1 + 2 = 3 !", result);
    }
    
    public void testReplaceFunction2(){
        BaseElRegex regex = new BaseElRegex();
        String result = regex.replaceFunction(null, "${dateC.format('Sun Mar 11 00:00:00 JST 2007' , 'yyyy/MM/dd')}");
        assertEquals("result", "2007/03/11", result); 
    }
    
    public void testReplaceFunction3(){
        BaseElRegex regex = new BaseElRegex();
        String result = regex.replaceFunction(null, "${dateC.format(\"Sun Mar 11 00:00:00 JST 2007\" , \"yyyy/MM/dd\")}");
        assertEquals("result", "2007/03/11", result); 
    }
}
