package test.org.itscool.commons.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.util.ArrayUtil;

public class ArrayUtilTest extends TestCase{
    public ArrayUtilTest(String name){
        super(name);
    }
    
    public void testIntAsc(){
        int[] array = { 1, 3, 6, 5};
        int[] ans ={ 1, 3, 5, 6 };
        int[] ret = ArrayUtil.sort(array, true);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testIntDec(){
        int[] array = { 1, 3, 6, 5};
        int[] ans ={ 6, 5, 3, 1 };
        int[] ret = ArrayUtil.sort(array, false);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testLongAsc(){
        long[] array = { 1000000, 3000000, 6000000, 5000000};
        long[] ans ={ 1000000, 3000000, 5000000, 6000000 };
        long[] ret = ArrayUtil.sort(array, true);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testLongDec(){
        long[] array = { 1000000, 3000000, 6000000, 5000000};
        long[] ans ={ 6000000, 5000000, 3000000, 1000000 };
        long[] ret = ArrayUtil.sort(array, false);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testStringAsc(){
        String[] array = { "ios tarou", "kano michiaki", "ios hanako", "abcdefg"};
        String[] ans ={ "abcdefg", "ios hanako", "ios tarou", "kano michiaki" };
        String[] ret = ArrayUtil.sort(array, true);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testStringAsc2(){
        String[] array = { "ACIX Y", "[ [", "ACIX Ԏq", " eXg"};
        String[] ans ={ "ACIX Y", "ACIX Ԏq", " eXg", "[ [" };
        String[] ret = ArrayUtil.sort(array, true);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
    
    public void testStringDec(){
        String[] array = { "ios tarou", "kano michiaki", "ios hanako", "abcdefg"};
        String[] ans ={ "kano michiaki","ios tarou", "ios hanako", "abcdefg" };
        String[] ret = ArrayUtil.sort(array, false);
        String retStr = ArrayUtil.getArrayString(ret);
        String ansStr = ArrayUtil.getArrayString(ans);
        
        assertEquals( "\[ǧʂsv ret[" + retStr + "] ans[" + ansStr + "]", 
            ArrayUtil.isMatch(ret, ans), true);
    }
	public static Test suite() {
		return new TestSuite(ArrayUtilTest.class);
	}
}

