package test.org.itscool.commons.dao3;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.weber.testcase.WeberDbTestCase;

public class DateDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
    }
    
    public void testInsert(){
        DateBean company = new DateBean();
        company.setId(100);
        company.setName("hoge com");
        company.setDateTm(new Date());
        company.setDateFd(new Date());
//        company.setTimeFd(new Date());
        company.setTimeSp(new Date());
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DateBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            dao.insert(crt, company);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        
        try{
            if(Transaction.PLEASE_COMMIT == trn.getTranStatus()){
                TransactionUtil.commitTransaction();
            }else if(Transaction.PLEASE_ROLLBACK == trn.getTranStatus()){
                TransactionUtil.rollbackTransaction();
            }
        }catch( Exception e){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
    public void testUpdate(){
        DateBean company = new DateBean();
        company.setId(200);
        company.setName("hoge com");
        company.setDateTm(new Date());
        company.setDateFd(new Date());
//        company.setTimeFd(new Date());
        company.setTimeSp(new Date());
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DateBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            dao.update(crt, company);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        
        try{
            if(Transaction.PLEASE_COMMIT == trn.getTranStatus()){
                TransactionUtil.commitTransaction();
            }else if(Transaction.PLEASE_ROLLBACK == trn.getTranStatus()){
                TransactionUtil.rollbackTransaction();
            }
        }catch( Exception e){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
//    public void testSelect(){
//        BaseDao dao = new BaseDao();
//        Criteria crt = new Criteria(DateBean.class);
//        crt.eq( DateBean.PK_COLUM_id, 1 );
//        
//        List list = dao.select(crt);
//        assertEquals( list.size(), 1 );
//        
//        DateBean company = (DateBean)list.get(0);
//        
//        System.out.println(company.getDateTm());
//        
//        assertEquals(1, company.getId());
//        assertEquals("{", company.getName());
//        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        String value = sdf1.format(company.getDateTm());
//        assertEquals("2001-01-01 10:12:10", value);
//    }
    
}
