package test.org.itscool.commons.aop;
import junit.framework.TestCase;

import org.itscool.commons.aop.ProxyMethodInvocator;


public class AdviceTest extends TestCase{
	
	public static void test1(){
		Hello hello = new HelloImpl();
		System.out.println("test1()->" + hello.sayHello());
		assertEquals(hello.getName(), "hogehoge");
	}
	
	public static void test2(){
		ProxyMethodInvocator proxy = new ProxyMethodInvocator(new HelloImpl(), Hello.class);
		proxy.addAdvice("sayHello", new HelloAdvice());
		Hello hello = (Hello)proxy.getProxy();
		System.out.println("test2()->" + hello.sayHello());
		assertEquals(hello.getName(), "kano");
	}
	
	public static void test3(){
		ProxyMethodInvocator proxy = new ProxyMethodInvocator(new HelloImpl(), Hello.class);
		proxy.addAdvice("sayHello", new HelloAdvice());
		ProxyMethodInvocator proxy2 = new ProxyMethodInvocator(new HelloImpl(), Hello.class);
		proxy2.addAdvice("sayHello", new HelloAdvice2());
		proxy2.addAdvice("sayGoodBy", new HelloAdvice3());
		
		Hello hello = (Hello)proxy.getProxy();
		System.out.println("test3() " + hello.sayHello());
		assertEquals(hello.getName(), "kano");
		
		Hello hello2 = (Hello)proxy2.getProxy();
		System.out.println("test3() " + hello2.sayHello());
		assertEquals(hello2.getName(), "hanako");
		System.out.println("test3() " + hello2.sayGoodBy());
	}
}


