/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.itscool.commons.aop.ProxyMethodHandler;
import org.itscool.commons.collection.KeyLinkedList;

public class ProxyMethodInvocator
implements InvocationHandler {
    private Object proxy;
    private Object original;
    private Object[] args;
    private Method method;
    private Object result = null;
    private KeyLinkedList adviceMap = new KeyLinkedList();
    private int chainCounter = 0;

    public ProxyMethodInvocator(Object implementsObject, Class interfaceName) {
        this.proxy = Proxy.newProxyInstance(interfaceName.getClassLoader(), new Class[]{interfaceName}, (InvocationHandler)this);
        this.original = implementsObject;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.args = args;
            this.method = method;
            List handlers = this.adviceMap.getList(method.getName());
            int size = handlers.size();
            if (size == 0) {
                return method.invoke(this.original, args);
            }
            if (this.chainCounter < size) {
                ProxyMethodHandler handler = (ProxyMethodHandler)handlers.get(this.chainCounter);
                this.result = handler.invoke(this);
            }
            return this.result;
        }
        catch (InvocationTargetException e) {
            this.chainCounter = 0;
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public Object proceed() throws Throwable {
        try {
            ++this.chainCounter;
            List handlers = this.adviceMap.getList(this.method.getName());
            int size = handlers.size();
            if (this.chainCounter < size) {
                ProxyMethodHandler handler = (ProxyMethodHandler)handlers.get(this.chainCounter);
                return handler.invoke(this);
            }
            this.chainCounter = 0;
            return this.method.invoke(this.original, this.args);
        }
        catch (InvocationTargetException e) {
            this.chainCounter = 0;
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public void addAdvice(String methodName, ProxyMethodHandler handler) {
        this.adviceMap.put(methodName, handler);
    }

    public void addAdvice(ProxyMethodHandler handler) {
        this.adviceMap.put(handler.getClass().getName(), handler);
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public Object getOriginal() {
        return this.original;
    }
}

