/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.function;

import java.util.Calendar;
import java.util.Date;
import org.itscool.commons.util.DateElement;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.MonthTable;

public class CalendarC {
    public static final String LINE = "\n";
    public static final String TAB = "    ";
    StringBuffer sb = new StringBuffer();

    public String draw(Date date) {
        if (date == null) {
            return "";
        }
        MonthTable month = new MonthTable(date);
        if (month == null) {
            month = new MonthTable();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.createMonthTag(month));
        return sb.toString();
    }

    public String draw(String dateStr) {
        if (dateStr == null || dateStr.length() == 0) {
            return "";
        }
        try {
            Date date = DateFormatUtil.parse((String)dateStr);
            return this.draw(date);
        }
        catch (Exception e) {
            return "CalendarC.draw()" + e.getMessage();
        }
    }

    protected String createMonthTag(MonthTable month) {
        StringBuffer sb = new StringBuffer();
        DateElement day = month.getDay(month.getYear(), month.getMonth(), 1);
        sb.append("<table class=\"calendar\">").append(LINE);
        sb.append(this.createHeader());
        int firstYobi = day.getYobi();
        if (firstYobi != 1) {
            Calendar cal = DateFormatUtil.getLastMonthWeek((int)month.getYear(), (int)month.getMonth());
            sb.append("<tr>").append(LINE);
            for (int i = 1; i < firstYobi; ++i) {
                day = month.getDay(cal);
                sb.append(this.createDayTag(day));
                cal.add(5, 1);
            }
        }
        for (int i = 0; i < month.getMaxday(); ++i) {
            day = month.getDay(month.getYear(), month.getMonth(), i + 1);
            sb.append(this.createDayTag(day));
        }
        DateElement lastDay = month.getDay(month.getYear(), month.getMonth(), month.getMaxday());
        if (lastDay.getYobi() != 7) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, month.getYear());
            cal.set(2, month.getMonth() - 1);
            cal.set(5, month.getMaxday());
            cal.add(5, 1);
            for (int i = lastDay.getYobi(); i < 7; ++i) {
                day = month.getDay(cal);
                sb.append(this.createDayTag(day));
                cal.add(5, 1);
            }
            if (day.getYobi() != 7) {
                sb.append("</tr>").append(LINE);
            } else {
                sb.append(LINE);
            }
        }
        sb.append("</table>");
        return sb.toString();
    }

    protected String createDayTag(DateElement day) {
        StringBuffer sb = new StringBuffer();
        if (day.getYobi() == 1) {
            sb.append("<tr>").append(LINE);
        }
        if (day.isHoliday()) {
            sb.append(TAB).append("<td class=\"holiday\" align=\"center\">");
        } else if (day.getYobi() == 1) {
            sb.append(TAB).append("<td class=\"sunday\" align=\"center\">");
        } else if (day.getYobi() == 7) {
            sb.append(TAB).append("<td class=\"saturday\" align=\"center\">");
        } else {
            sb.append(TAB).append("<td class=\"day\" align=\"center\">");
        }
        sb.append(this.createDayBodyContents(day));
        sb.append("</td>").append(LINE);
        if (day.getYobi() == 7) {
            sb.append("</tr>").append(LINE);
        }
        return sb.toString();
    }

    protected String createDayBodyContents(DateElement day) {
        String body = String.valueOf(day.getDay());
        return body;
    }

    protected String createHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append(LINE);
        StringBuffer td = new StringBuffer();
        td.append(TAB);
        td.append("<td class=\"header\">");
        sb.append(td.toString()).append("\u65e5").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6708").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u706b").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6c34").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u6728").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u91d1").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("\u571f").append("</td>");
        sb.append(LINE);
        sb.append("</tr>").append(LINE);
        return sb.toString();
    }
}

