/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputCheckUtil {
    public static boolean checkFullSize(String str) {
        byte[] bytes = str.getBytes();
        int beams = str.length() * 2;
        boolean enterCounter = false;
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < str.length(); ++i) {
            if ('\n' != sb.charAt(i)) continue;
            beams -= 2;
        }
        return beams == bytes.length;
    }

    public static boolean checkHalfSize(String str) {
        byte[] bytes = str.getBytes();
        int beams = str.length();
        boolean enterCounter = false;
        StringBuffer sb = new StringBuffer(str);
        for (int i = 0; i < str.length(); ++i) {
            if ('\n' != sb.charAt(i)) continue;
            beams -= 2;
        }
        return beams == bytes.length;
    }

    public static boolean checkDigit(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean checkAlphabet(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean checkDigitAlphabet(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean checkHankakuKana(String input) {
        String HANKAKU_KANA = "\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff9e\uff9f\uff70\uff64\uff61\uff62\uff63\uff65";
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (-1 != "\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff67\uff68\uff69\uff6a\uff6b\uff6f\uff6c\uff6d\uff6e\uff9e\uff9f\uff70\uff64\uff61\uff62\uff63\uff65".indexOf(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkStrLength(String val, int min, int max) {
        int strlen = 0;
        if (val == null) {
            return false;
        }
        strlen = val.getBytes().length;
        return strlen >= min && strlen <= max;
    }

    public static boolean checkDigitLength(String str, double min, double max) {
        double value;
        try {
            value = Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return min <= value && value <= max;
    }

    public static boolean checkRequerd(String str) {
        return str != null && str.length() != 0;
    }

    public static boolean checkTelNo(String data) {
        if (!InputCheckUtil.checkRequerd(data)) {
            return false;
        }
        String koubun = "\\d{1,4}?-\\d{1,4}?-\\d{1,4}";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b = matcher.matches();
        return true;
    }

    public static boolean checkMailAddr(String data) {
        if (!InputCheckUtil.checkRequerd(data)) {
            return false;
        }
        String koubun = "[!#-9A-~]+@[a-z0-9-_]+\\.+[a-z0-9-_]+\\.+[a-z0-9-]";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b = matcher.matches();
        return true;
    }

    public static boolean checkPostCode(String data) {
        if (!InputCheckUtil.checkRequerd(data)) {
            return false;
        }
        String koubun = "\\d{3}-\\d{4}";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b = matcher.matches();
        return true;
    }

    public static boolean checkUrl(String data) {
        if (!InputCheckUtil.checkRequerd(data)) {
            return false;
        }
        String koubun = "http://[\\w\\d/%#$&?()~_.=+-]+";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b = matcher.matches();
        return true;
    }
}

