/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractLog {
    public static final String TRACE = "trace";
    public static final String DEBUG = "debug";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    public static final String DISP_MODE = "disp";
    public static final String FILE_MODE = "file";
    public static final String ALLOUT_MODE = "all";
    protected boolean init;
    protected int maxSize;
    protected String logPath;
    protected String level = "warn";
    protected int levelInt = 2;
    protected String mode = "disp";
    protected String encode;
    protected List traces = new ArrayList();
    protected List debugs = new ArrayList();
    protected List infos = new ArrayList();
    protected List warns = new ArrayList();
    protected List errors = new ArrayList();
    protected List fatals = new ArrayList();

    public void setInfos(List infos) {
        this.infos = infos;
    }

    public List getInfos() {
        return this.infos;
    }

    public boolean isOutputClass(String clazzName, String levelNow) {
        boolean ret = false;
        if (this.isOutputClass(this.traces, clazzName)) {
            return 0 <= this.getLevelNum(levelNow);
        }
        if (this.isOutputClass(this.infos, clazzName)) {
            return 1 <= this.getLevelNum(levelNow);
        }
        if (this.isOutputClass(this.warns, clazzName)) {
            return 2 <= this.getLevelNum(levelNow);
        }
        if (this.isOutputClass(this.errors, clazzName)) {
            return 3 <= this.getLevelNum(levelNow);
        }
        if (this.isOutputClass(this.fatals, clazzName)) {
            return 4 <= this.getLevelNum(levelNow);
        }
        return this.levelInt <= this.getLevelNum(levelNow);
    }

    protected boolean isOutputClass(List levels, String clazzName) {
        boolean ret = false;
        int size = levels.size();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String pattern = (String)levels.get(i);
            if (clazzName.indexOf(pattern) != 0) continue;
            return true;
        }
        return ret;
    }

    public String getLevel() {
        return this.level;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getMode() {
        return this.mode;
    }

    public abstract void trace(String var1);

    public abstract void debug(String var1);

    public abstract void info(String var1);

    public abstract void warn(String var1);

    public abstract void error(String var1);

    public abstract void fatal(String var1);

    public abstract void trace(Exception var1);

    public abstract void debug(Exception var1);

    public abstract void info(Exception var1);

    public abstract void warn(Exception var1);

    public abstract void error(Exception var1);

    public abstract void fatal(Exception var1);

    public abstract void trace(Error var1);

    public abstract void debug(Error var1);

    public abstract void info(Error var1);

    public abstract void warn(Error var1);

    public abstract void error(Error var1);

    public abstract void fatal(Error var1);

    protected abstract void out(String var1, String var2, int var3);

    protected abstract void out(Exception var1, String var2);

    protected abstract void out(Error var1, String var2);

    public static String getLogKind(String levelNow) {
        if (levelNow.equals(TRACE)) {
            return "DEBUG";
        }
        if (levelNow.equals(INFO)) {
            return "INFO ";
        }
        if (levelNow.equals(WARN)) {
            return "WORN ";
        }
        if (levelNow.equals(ERROR)) {
            return "ERROR";
        }
        if (levelNow.equals(FATAL)) {
            return "SYSTEM";
        }
        return "DEBUG";
    }

    public static String getLogMode(String mode) {
        if (mode.equals(DISP_MODE)) {
            return "DISP ONLY";
        }
        if (mode.equals(FILE_MODE)) {
            return "FILE ONLY";
        }
        return "DISP & FILE ";
    }

    protected static String getNowDate() {
        Calendar date = Calendar.getInstance();
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        String monthPadding = "";
        String dayPadding = "";
        String hourPadding = "";
        String minutePadding = "";
        String secondPadding = "";
        if (month < 10) {
            monthPadding = "0";
        }
        if (day < 10) {
            dayPadding = "0";
        }
        if (hour < 10) {
            hourPadding = "0";
        }
        if (minute < 10) {
            minutePadding = "0";
        }
        if (second < 10) {
            secondPadding = "0";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(year).append("/");
        ret.append(monthPadding).append(month).append("/");
        ret.append(dayPadding).append(day).append(" ");
        ret.append(hourPadding).append(hour).append(":");
        ret.append(minutePadding).append(minute).append(":");
        ret.append(secondPadding).append(second);
        return ret.toString();
    }

    protected static String getNowDateYYYYMMDDHHMMSS() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        String month = String.valueOf(date.get(2));
        String day = String.valueOf(date.get(5));
        String hour = String.valueOf(date.get(10));
        String minute = String.valueOf(date.get(12));
        String second = String.valueOf(date.get(13));
        return year + month + day + hour + minute + second;
    }

    protected static String getNowDateYYYYMMDD() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        String month = String.valueOf(date.get(2));
        String day = String.valueOf(date.get(5));
        return year + month + day;
    }

    protected synchronized void sizeCheck() {
        File file = new File(this.logPath);
        if (file.canRead() && file.length() >= (long)(this.maxSize * 1024)) {
            file.renameTo(new File(this.logPath + "." + AbstractLog.getNowDateYYYYMMDDHHMMSS()));
        }
        file = null;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void setLevel(String level) {
        this.level = level;
        this.levelInt = this.getLevelNum(level);
    }

    protected int getLevelNum(String level) {
        this.level = level;
        if (level.equals(TRACE)) {
            return 0;
        }
        if (level.equals(DEBUG)) {
            return 1;
        }
        if (level.equals(INFO)) {
            return 2;
        }
        if (level.equals(WARN)) {
            return 3;
        }
        if (level.equals(ERROR)) {
            return 4;
        }
        if (level.equals(FATAL)) {
            return 5;
        }
        return 1;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public List getTraces() {
        return this.traces;
    }

    public void setTraces(List debugs) {
        this.traces = debugs;
    }

    public List getWarns() {
        return this.warns;
    }

    public void setWarns(List warns) {
        this.warns = warns;
    }

    public List getErrors() {
        return this.errors;
    }

    public void setErrors(List errors) {
        this.errors = errors;
    }

    public List getFatals() {
        return this.fatals;
    }

    public void setFatals(List fatals) {
        this.fatals = fatals;
    }

    public List getDebugs() {
        return this.debugs;
    }

    public void setDebugs(List debugs) {
        this.debugs = debugs;
    }
}

