/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

public class ProxyConnection {
    Connection connection;
    LinkedList openedStatements;
    LinkedList openedResultSets;
    Object proxy;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;

    ProxyConnection(Connection org) {
        this.connection = org;
        this.openedStatements = new LinkedList();
        this.openedResultSets = new LinkedList();
        this.proxy = Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler());
    }

    public static Connection createProxy(Connection c) {
        ProxyConnection pc = new ProxyConnection(c);
        return (Connection)pc.proxy;
    }

    Object send(Object target, Method m, Object[] args) throws Throwable {
        try {
            return m.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    void remove(Object o) {
        if (o instanceof ResultSet) {
            this.openedResultSets.remove(o);
        } else if (o instanceof Statement) {
            this.openedStatements.remove(o);
        } else {
            throw new IllegalArgumentException("bad class:" + o);
        }
    }

    void closeAll() {
        int i;
        int size = this.openedResultSets.size();
        for (i = 0; i < size; ++i) {
            ResultSet rs = (ResultSet)this.openedResultSets.get(i);
            try {
                rs.close();
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        size = this.openedStatements.size();
        for (i = 0; i < size; ++i) {
            Statement ps = (Statement)this.openedStatements.get(i);
            try {
                ps.close();
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    class Delegate
    implements InvocationHandler {
        Object proxy;
        Object original;

        Delegate(Object o, Class c) {
            this.original = o;
            this.proxy = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object o;
            if (method.getName().equals("close")) {
                ProxyConnection.this.remove(this.original);
            }
            if ((o = ProxyConnection.this.send(this.original, method, args)) instanceof ResultSet) {
                ProxyConnection.this.openedResultSets.add((ResultSet)o);
                o = (ProxyConnection)ProxyConnection.this.new Delegate((Object)o, (Class)(ProxyConnection.class$java$sql$ResultSet == null ? (ProxyConnection.class$java$sql$ResultSet = ProxyConnection.class$((String)"java.sql.ResultSet")) : ProxyConnection.class$java$sql$ResultSet)).proxy;
            }
            return o;
        }
    }

    class ConnectionHandler
    implements InvocationHandler {
        ConnectionHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object o;
            if (method.getName().equals("close")) {
                ProxyConnection.this.closeAll();
            }
            if ((o = ProxyConnection.this.send(ProxyConnection.this.connection, method, args)) instanceof Statement) {
                ProxyConnection.this.openedStatements.add((Statement)o);
                o = (ProxyConnection)ProxyConnection.this.new Delegate((Object)o, (Class)(ProxyConnection.class$java$sql$PreparedStatement == null ? (ProxyConnection.class$java$sql$PreparedStatement = ProxyConnection.class$((String)"java.sql.PreparedStatement")) : ProxyConnection.class$java$sql$PreparedStatement)).proxy;
            }
            return o;
        }
    }
}

