/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.controller;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.itscool.commons.util.StringUtil;
import org.itscool.weber.action.LoginAction;
import org.itscool.weber.action.LogoutAction;
import org.itscool.weber.action.NoOpAction4x;
import org.itscool.weber.user.User;

public class RequestDispatcher {
    private String fullPath = "";
    private String etcPath = "";
    private String moduleName = "";
    private String actionName = "";

    public RequestDispatcher(String path) {
        this.fullPath = path;
        StringTokenizer st = new StringTokenizer(path, "/");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            tokens.add(element);
        }
        int tokenSize = tokens.size();
        if (tokenSize < 2) {
            return;
        }
        if (tokenSize == 2) {
            this.moduleName = (String)tokens.get(0);
            this.actionName = (String)tokens.get(1);
        } else {
            this.moduleName = (String)tokens.get(tokenSize - 2);
            this.actionName = (String)tokens.get(tokenSize - 1);
            for (int i = 0; i < tokenSize - 2; ++i) {
                this.etcPath = this.etcPath + (String)tokens.get(i) + "/";
            }
        }
        this.moduleName = this.moduleName.length() == 1 ? this.moduleName.toUpperCase() : this.moduleName.substring(0, 1).toUpperCase() + this.moduleName.substring(1, this.moduleName.length());
        int lastDotPos = this.actionName.lastIndexOf(".");
        if (lastDotPos >= 1) {
            if (this.actionName.length() == 1) {
                this.actionName = this.actionName.toUpperCase();
            } else {
                this.actionName = this.actionName.substring(0, lastDotPos);
                this.actionName = this.actionName.substring(0, 1).toUpperCase() + this.actionName.substring(1, this.actionName.length());
            }
        }
        this.moduleName = StringUtil.cnvUnderScorNameToUpperName((String)this.moduleName);
        this.actionName = StringUtil.cnvUnderScorNameToUpperName((String)this.actionName);
    }

    public String getPkgActionName(String pkgName) {
        if ((this.moduleName + this.actionName).equals("WeberLogin")) {
            return LoginAction.class.getName();
        }
        if ((this.moduleName + this.actionName).equals("WeberLogout")) {
            return LogoutAction.class.getName();
        }
        if (StringUtil.cnvUpperNameToUnderScoreName((String)this.actionName).equals("no_operation")) {
            return NoOpAction4x.class.getName();
        }
        String clazzName = pkgName + "." + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "." + this.moduleName + this.actionName + "Action";
        return clazzName;
    }

    public String getFormName(String pkgName) {
        if ((this.moduleName + this.actionName).equals("WeberLogin")) {
            return User.class.getName();
        }
        if ((this.moduleName + this.actionName).equals("WeberLogout")) {
            return User.class.getName();
        }
        if (this.actionName.equals("no_operation")) {
            return null;
        }
        String clazzName = pkgName + "." + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "." + this.moduleName;
        return clazzName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getReturnPath(String ret) {
        String returnName = "";
        if (ret == null || ret.trim().length() == 0) {
            returnName = "/" + this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
            String moduleActionName = this.moduleName + this.actionName;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)moduleActionName);
            return returnName;
        }
        if ((ret = ret.length() == 1 ? ret.toUpperCase() : ret.substring(0, 1).toUpperCase() + ret.subSequence(1, ret.length())).toLowerCase().equals("input_error")) {
            returnName = "/" + this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
            String moduleActionName = this.moduleName + this.actionName;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)moduleActionName);
        } else if ((this.moduleName + this.actionName).equals("WeberLogin")) {
            returnName = "/" + this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
            String moduleActionName = this.moduleName + this.actionName + ret;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)moduleActionName);
        } else if ((this.moduleName + this.actionName).equals("WeberLogout")) {
            returnName = "/" + this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
            String moduleActionName = this.moduleName + this.actionName + ret;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)moduleActionName);
        } else {
            returnName = "/" + this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
            String moduleActionName = this.moduleName + ret;
            returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)moduleActionName);
        }
        return returnName;
    }
}

