package test.org.itscool.commons.document;

import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.itscool.commons.document.BeanToXmlDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

import sample.org.itscool.ajax2.Computer;
import test.org.itscool.commons.bean.BeanSampleEx;


public class BeanToXmlDocument2Test extends TestCase{
    
    public void testParse1(){
        try{
            BeanSampleEx bean = new BeanSampleEx();
            bean.setId(100);
            bean.setName("aho aho");
            bean.setAFlag(true);
            //VXMLhLg쐬܂
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            beanToXml.addElement(bean);
            Document document = beanToXml.getDocument();
            
            String text = beanToXml.parseText("Shift_JIS");
            System.out.println("----test1----");
            System.out.println(text);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    public void testParse2(){
        try{
            BeanSampleEx bean = new BeanSampleEx();
            bean.setId(100);
            bean.setName("aho aho");
            bean.setAFlag(true);
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            
            beanToXml.addElement(bean);
            
            bean.setName("hoge hoge");
            beanToXml.addElement(bean);
            
            Document document = beanToXml.getDocument();
            
            String text = beanToXml.parseText("Shift_JIS");
            System.out.println("----test2----");
            System.out.println(text);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    public void testParse3(){
        try{
            BeanSampleEx bean = new BeanSampleEx();
            bean.setId(100);
            bean.setName("hanako");
            bean.setAFlag(true);
            
            BeanSampleEx bean2 = new BeanSampleEx();
            bean2.setId(200);
            bean2.setName("tarou");
            bean2.setAFlag(false);
            
            ArrayList list = new ArrayList();
            list.add(bean);
            list.add(bean2);
            
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            
            beanToXml.addElement(list);
            
            Document document = beanToXml.getDocument();
            
            String text = beanToXml.parseText("Shift_JIS");
            System.out.println("----test3----");
            System.out.println(text);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    public void testParse4(){
        try{
//			hLgIuWFNg̍쐬
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            
            DOMImplementation domImpl = builder.getDOMImplementation();
            
            Document document = domImpl.createDocument("","mart",null);
            
            //XMLhLggp܂
            BeanToXmlDocument beanToXml = new BeanToXmlDocument(document);
            
            Computer computer = new Computer();
            computer.setModel("KANOf1");
            computer.setOs("WindowsXP Home");
            computer.setCpu("Celeron2 Gh");
            computer.setMemory("SDRAM 256MB");
            computer.setHdd("40GB 7200rpm");
            computer.setDvd("CD-ROM");
            computer.setDisplay("KANO");
            computer.setPrice("62,000");
            
            //̃hLgɐVvfǉ܂
            beanToXml.addElement(computer, "computer");
            
            String text = beanToXml.parseText("Shift_JIS");
            System.out.println("----test4----");
            System.out.println(text);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
}



