/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;

public class Criteria {
    protected static final String line = System.getProperty("line.separator");
    protected static final String tab = "    ";
    protected RecordMap gRecordMap;
    protected LinkedList whereList;
    protected LinkedList orderByList;
    protected LinkedList groupByList;
    protected HashMap fkRecordMaps;
    protected String limit = null;

    public void setLimit(int startRow, int row) {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        if (startRow > 0) {
            --startRow;
        }
        this.limit = dbType.equals("hsql") ? "LIMIT " + startRow + " " + row : "LIMIT " + startRow + ", " + row;
    }

    public String getLimit() {
        return this.limit;
    }

    public Criteria(Class entity) {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        this.gRecordMap = mapping.getGRecordMap(entity);
        this.fkRecordMaps = mapping.getFkRecordMaps(entity);
        if (this.gRecordMap == null) {
            this.gRecordMap = RecordMapFactory.createRecordMap(entity);
        }
        if (this.fkRecordMaps == null) {
            this.fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
        }
        this.orderByList = new LinkedList();
        this.groupByList = new LinkedList();
        this.whereList = new LinkedList();
    }

    public RecordMap getRecord() {
        return this.gRecordMap;
    }

    protected String getColNames(RecordMap record) {
        StringBuffer sb = new StringBuffer(line);
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String colWithTableName = item.getColumWithTableName();
            String colAsName = item.getColumAsName();
            sb.append(tab);
            sb.append(colWithTableName);
            sb.append(" as ");
            sb.append(colAsName);
            if (!it.hasNext()) continue;
            sb.append(",");
            sb.append(line);
        }
        return sb.toString();
    }

    protected String getColNamesByTable(HashMap records) {
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            sb.append(this.getColNames(recordMap));
        }
        return sb.toString();
    }

    protected String getTableNames(HashMap records) {
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            sb.append(recordMap.getTableName());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.gRecordMap.toString());
        sb.append(line);
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap recordMap = (RecordMap)this.fkRecordMaps.get(key);
            sb.append("FK_KEY[").append(key).append("] ").append(recordMap.toString());
            sb.append(line);
        }
        return sb.toString();
    }

    public String toSelectString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        if (dbType.equals("hsql") && this.limit != null) {
            sql.append(line + tab);
            sql.append(this.limit);
        }
        sql.append(this.getColNames(this.gRecordMap));
        sql.append(this.getFkSelectString());
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0 || deleteFg != null) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        if (deleteFg != null) {
            if (this.whereList.size() > 0) {
                sql.append(line + tab);
                sql.append("AND ");
            }
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        sql.append(this.getFkWhereString());
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        if (this.orderByList.size() > 0) {
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(this.getOrderByString());
        }
        if (!dbType.equals("hsql") && this.limit != null) {
            sql.append(line + tab);
            sql.append(this.limit);
        }
        return sql.toString();
    }

    public String toCountString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" COUNT(*) AS DATA_NUM");
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0 || deleteFg != null) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        if (deleteFg != null) {
            if (this.whereList.size() > 0) {
                sql.append(line + tab);
                sql.append("AND ");
            }
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        sql.append(this.getFkWhereString());
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        return sql.toString();
    }

    private String getFkSelectString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            sql.append(this.getColNames(fkRecordMap));
            if (!it.hasNext()) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private String getFkTableString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
            sql.append(line + tab);
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            String fkTableName = fkRecordMap.getTableName();
            sql.append(fkTableName);
            if (!it.hasNext()) continue;
            sql.append(",");
            sql.append(line + tab);
        }
        return sql.toString();
    }

    private String getFkWhereString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext() && (this.whereList.size() > 0 || this.gRecordMap.getFieldByFieldName("DELETE_FG") != null)) {
            sql.append(line + tab);
            sql.append("AND ");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            Set fieldKeySet = fkRecordMap.getFields().keySet();
            Iterator fieldIt = fieldKeySet.iterator();
            while (fieldIt.hasNext()) {
                String fieldKey = (String)fieldIt.next();
                FieldMap fieldMap = fkRecordMap.getField(fieldKey);
                if (!fieldMap.isForignKey()) continue;
                String propertyName = fieldMap.getPropertyName();
                String columWithTableName = fieldMap.getColumWithTableName();
                String fkPropertyName = fieldMap.getFkPropertyName();
                sql.append(columWithTableName);
                sql.append(" = ");
                sql.append(this.getFkFieldName(fkPropertyName));
                if (!it.hasNext()) continue;
                sql.append(line + tab);
                sql.append("AND ");
            }
        }
        return sql.toString();
    }

    private String getFkFieldName(String propertyName) {
        HashMap fields = this.gRecordMap.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        String fkFieldName = "";
        while (it.hasNext()) {
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            if (!fieldMap.getPropertyName().equals(propertyName)) continue;
            return fieldMap.getColumWithTableName();
        }
        return fkFieldName;
    }

    public String toDeleteString() {
        if (this.gRecordMap.getFieldByFieldName("DELETE_FG") != null) {
            return this.toLogicalDeleteString();
        }
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(" ").append(this.gRecordMap.getTableName()).append(" ");
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        return sql.toString();
    }

    public String toLogicalDeleteString() {
        StringBuffer sql = new StringBuffer("UPDATE ");
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        FieldMap deleteDt = this.gRecordMap.getFieldByFieldName("DELETE_DT");
        sql.append(line);
        sql.append(" ").append(this.gRecordMap.getTableName()).append(" ");
        sql.append(" SET ");
        sql.append(line + tab);
        sql.append(deleteFg.getColumWithTableName());
        sql.append("=1");
        if (deleteDt != null) {
            sql.append(", ");
            sql.append(deleteDt.getColumWithTableName());
            sql.append("=");
            sql.append(deleteDt.cnvSqlValue(new Date()));
        }
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        return sql.toString();
    }

    public String toInsertString(Object bean) {
        StringBuffer sql = new StringBuffer("INSERT INTO");
        HashMap fields = this.gRecordMap.getFields();
        sql.append(" ").append(this.gRecordMap.getTableName());
        sql.append("(");
        sql.append(Criteria.toItemNames(fields));
        sql.append(") VALUES(");
        sql.append(Criteria.toItemValues(fields, bean));
        sql.append(")");
        return sql.toString();
    }

    public String toUpdateString(Object bean) {
        StringBuffer sql = new StringBuffer("UPDATE");
        HashMap fields = this.gRecordMap.getFields();
        Object version = null;
        try {
            version = this.getLockVersion(bean);
        }
        catch (Exception e) {
            // empty catch block
        }
        sql.append(" ").append(this.gRecordMap.getTableName()).append(line);
        sql.append("SET ").append(line + tab);
        sql.append(Criteria.toUpdateNames(fields, bean));
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        if (version != null) {
            if (this.whereList.size() == 0) {
                sql.append(line);
                sql.append("WHERE").append(line + tab);
            } else {
                sql.append(line + tab).append("AND ");
            }
            try {
                int versionNum = Integer.parseInt(version.toString());
                if (versionNum == 0) {
                    sql.append("(");
                    sql.append("LOCK_VERSION").append(" = ").append(version);
                    sql.append(" OR ").append("LOCK_VERSION").append(" is null");
                    sql.append(")");
                } else {
                    sql.append("LOCK_VERSION").append(" = ").append(version);
                }
            }
            catch (Exception e) {
                sql.append("LOCK_VERSION").append(" = ").append(version);
            }
        }
        return sql.toString();
    }

    public Object getLockVersion(Object bean) throws BeanUtilRuntimeException {
        FieldMap rockVersionField = this.gRecordMap.getFieldByFieldName("LOCK_VERSION");
        if (rockVersionField == null) {
            return null;
        }
        Object version = BeanUtil.getProperty(bean, rockVersionField.getPropertyName());
        return version;
    }

    protected static String toUpdateNames(HashMap fields, Object bean) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        boolean nextFlg = false;
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            if (item.isPrimaryKey()) continue;
            if (nextFlg) {
                sb.append(",");
                sb.append(line + tab);
            }
            String propertyName = item.getPropertyName();
            Object value = BeanUtil.getProperty(bean, propertyName);
            sb.append(item.getColumName());
            sb.append("=");
            if (item.getColumName().equals("LOCK_VERSION")) {
                value = String.valueOf(Integer.parseInt(value.toString()) + 1);
                sb.append(value);
            } else if (item.getColumName().equals("UPDATE_DT")) {
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                sb.append(value);
            } else {
                sb.append(item.cnvSqlValue(value));
            }
            if (nextFlg) continue;
            nextFlg = true;
        }
        return sb.toString();
    }

    public String toSelectLockVersionString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        FieldMap lckField = this.gRecordMap.getFieldByFieldName("LOCK_VERSION");
        if (lckField == null) {
            return null;
        }
        sql.append(line + tab);
        sql.append(this.gRecordMap.getTableName()).append(".");
        sql.append(lckField.getColumName());
        sql.append(" AS ").append(lckField.getColumName());
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        sql.append(this.getFkWhereString());
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        if (this.orderByList.size() > 0) {
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(this.getOrderByString());
        }
        return sql.toString();
    }

    protected static String toItemNames(HashMap fields) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            sb.append(item.getColumName().toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected static String toItemValues(HashMap fields, Object bean) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String propertyName = item.getPropertyName();
            Object value = BeanUtil.getProperty(bean, propertyName);
            if (item.getColumName().equals("LOCK_VERSION")) {
                value = String.valueOf(1);
                BeanUtil.setProperty(bean, propertyName, value);
                sb.append(value);
            } else if (item.getColumName().equals("UPDATE_DT")) {
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                BeanUtil.setProperty(bean, propertyName, updateDt);
                sb.append(value);
            } else if (item.getColumName().equals("DELETE_DT")) {
                sb.append("null");
            } else {
                sb.append(item.cnvSqlValue(value));
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String getWhereString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.whereList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql);
        }
        return sb.toString();
    }

    public String getOrderByString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.orderByList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String getGroupByString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.groupByList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void or() {
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("OR ");
        this.whereList.add(sb.toString());
    }

    public void and() {
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("AND ");
        this.whereList.add(sb.toString());
    }

    public void orderby(String field, boolean sort) {
        String sortStr = "";
        sortStr = sort ? "ASC" : "DESC";
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(field);
        sb.append(" ").append(sortStr);
        this.orderByList.add(sb.toString());
    }

    public void groupby(String field) {
        String sortStr = "";
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(field);
        sb.append(" ").append(sortStr);
        this.groupByList.add(sb.toString());
    }

    public FieldMap getFkField(String fieldName) {
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            FieldMap fieldMap = fkRecordMap.getField(fieldName);
            if (fieldMap == null) continue;
            return fieldMap;
        }
        return null;
    }

    public void isnull(String field) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        StringBuffer sb = new StringBuffer();
        sb.append(field).append(" IS NULL");
        this.whereList.add(sb.toString());
    }

    public void isnotnull(String field) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        StringBuffer sb = new StringBuffer();
        sb.append(field).append(" IS NOT NULL");
        this.whereList.add(sb.toString());
    }

    public void between(String field, Object value1, Object value2) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        StringBuffer sb = new StringBuffer();
        sb.append(field);
        sb.append(" BETWEEN ");
        sb.append(fieldMap.cnvSqlValue(value1));
        sb.append(" AND ");
        sb.append(fieldMap.cnvSqlValue(value2));
        this.whereList.add(sb.toString());
    }

    public void between(String field, int value1, int value2) {
        this.between(field, String.valueOf(value1), String.valueOf(value2));
    }

    public void between(String field, short value1, short value2) {
        this.between(field, String.valueOf(value1), String.valueOf(value2));
    }

    public void between(String field, double value1, double value2) {
        this.between(field, String.valueOf(value1), String.valueOf(value2));
    }

    public void between(String field, long value1, long value2) {
        this.between(field, String.valueOf(value1), String.valueOf(value2));
    }

    public void between(String field, float value1, float value2) {
        this.between(field, String.valueOf(value1), String.valueOf(value2));
    }

    public void like(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        StringBuffer sb = new StringBuffer();
        sb.append(field).append(" ");
        sb.append("LIKE ");
        sb.append(fieldMap.cnvSqlValue(value));
        this.whereList.add(sb.toString());
    }

    public void like(String field, int value) {
        this.like(field, String.valueOf(value));
    }

    public void like(String field, short value) {
        this.like(field, String.valueOf(value));
    }

    public void like(String field, double value) {
        this.like(field, String.valueOf(value));
    }

    public void like(String field, long value) {
        this.like(field, String.valueOf(value));
    }

    public void like(String field, float value) {
        this.like(field, String.valueOf(value));
    }

    public void eq(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" = ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" = ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void eq(String field, int value) {
        this.eq(field, String.valueOf(value));
    }

    public void eq(String field, short value) {
        this.eq(field, String.valueOf(value));
    }

    public void eq(String field, double value) {
        this.eq(field, String.valueOf(value));
    }

    public void eq(String field, long value) {
        this.eq(field, String.valueOf(value));
    }

    public void eq(String field, float value) {
        this.eq(field, String.valueOf(value));
    }

    public void neq(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" != ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" != ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void neq(String field, short value) {
        this.neq(field, String.valueOf(value));
    }

    public void neq(String field, int value) {
        this.neq(field, String.valueOf(value));
    }

    public void neq(String field, long value) {
        this.neq(field, String.valueOf(value));
    }

    public void neq(String field, double value) {
        this.neq(field, String.valueOf(value));
    }

    public void neq(String field, float value) {
        this.neq(field, String.valueOf(value));
    }

    public void neq(String field, Date value) {
        this.neq(field, String.valueOf(value));
    }

    public void morebig(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" > ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" > ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void morebig(String field, short value) {
        this.morebig(field, String.valueOf(value));
    }

    public void morebig(String field, int value) {
        this.morebig(field, String.valueOf(value));
    }

    public void morebig(String field, long value) {
        this.morebig(field, String.valueOf(value));
    }

    public void morebig(String field, double value) {
        this.morebig(field, String.valueOf(value));
    }

    public void morebig(String field, float value) {
        this.morebig(field, String.valueOf(value));
    }

    public void morebig(String field, Date value) {
        this.morebig(field, String.valueOf(value));
    }

    public void moresmall(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" < ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" < ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void moresmall(String field, short value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void moresmall(String field, int value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void moresmall(String field, long value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void moresmall(String field, double value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void moresmall(String field, float value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void moresmall(String field, Date value) {
        this.moresmall(field, String.valueOf(value));
    }

    public void overbig(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" >= ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" >= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void overbig(String field, short value) {
        this.overbig(field, String.valueOf(value));
    }

    public void overbig(String field, int value) {
        this.overbig(field, String.valueOf(value));
    }

    public void overbig(String field, long value) {
        this.overbig(field, String.valueOf(value));
    }

    public void overbig(String field, double value) {
        this.overbig(field, String.valueOf(value));
    }

    public void overbig(String field, float value) {
        this.overbig(field, String.valueOf(value));
    }

    public void overbig(String field, Date value) {
        this.overbig(field, String.valueOf(value));
    }

    public void oversmall(String field, Object value) {
        FieldMap fieldMap = this.gRecordMap.getField(field);
        if (fieldMap == null) {
            fieldMap = this.getFkField(field);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(field).append(" <= ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" <= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
    }

    public void oversmall(String field, short value) {
        this.oversmall(field, String.valueOf(value));
    }

    public void oversmall(String field, int value) {
        this.oversmall(field, String.valueOf(value));
    }

    public void oversmall(String field, long value) {
        this.oversmall(field, String.valueOf(value));
    }

    public void oversmall(String field, double value) {
        this.oversmall(field, String.valueOf(value));
    }

    public void oversmall(String field, float value) {
        this.oversmall(field, String.valueOf(value));
    }

    public void oversmall(String field, Date value) {
        this.oversmall(field, String.valueOf(value));
    }

    public HashMap getFkRecordMaps() {
        return this.fkRecordMaps;
    }

    public void setFkRecordMaps(HashMap fkRecordMaps) {
        this.fkRecordMaps = fkRecordMaps;
    }
}

