/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileManager {
    private static final String TEMP_DIR_PREFIX = "tmp-mgr-";
    private static File sTmpDir = null;
    static /* synthetic */ Class class$0;

    static {
        System.out.println("\u30c6\u30f3\u30dd\u30e9\u30ea\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u3092\u958b\u59cb");
        FileFilter tmpDirFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(TempFileManager.TEMP_DIR_PREFIX);
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] tmpFiles = tmpDir.listFiles(tmpDirFilter);
        int i = 0;
        while (i < tmpFiles.length) {
            File tmpFile = tmpFiles[i];
            File lockFile = new File(tmpFile.getParent(), String.valueOf(tmpFile.getName()) + ".lck");
            if (!lockFile.exists()) {
                Logger.getLogger("default").log(Level.FINE, "TempFileManager::deleting old temp directory " + tmpFile);
                try {
                    TempFileManager.recursiveDelete(tmpFile);
                }
                catch (IOException ex) {
                    Logger.getLogger("default").log(Level.INFO, "TempFileManager::unable to delete " + tmpFile.getAbsolutePath());
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    ex.printStackTrace(new PrintStream(ostream));
                    Logger.getLogger("default").log(Level.FINE, ostream.toString());
                }
            } else {
                System.out.println("\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb\u304c\u6b8b\u3063\u3066\u3044\u307e\u3059\u304c\u524a\u9664\u3057\u3066\u307f\u307e\u3059 [" + lockFile.getName() + "]");
                try {
                    lockFile.delete();
                    TempFileManager.recursiveDelete(tmpFile);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        if (sTmpDir == null) {
            String tmpDirName = System.getProperty("java.io.tmpdir");
            File tmpDir = File.createTempFile(TEMP_DIR_PREFIX, ".tmp", new File(tmpDirName));
            tmpDir.delete();
            File lockFile = new File(tmpDirName, String.valueOf(tmpDir.getName()) + ".lck");
            lockFile.createNewFile();
            lockFile.deleteOnExit();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory:" + tmpDir.getAbsolutePath());
            }
            sTmpDir = tmpDir;
        }
        return File.createTempFile(prefix, suffix, sTmpDir);
    }

    public static void tmpClean() {
    }

    public static void main(String[] args) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.itscool.commons.util.TempFileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class.forName(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private static void recursiveDelete(File rootDir) throws IOException {
        File[] files = rootDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                TempFileManager.recursiveDelete(rootDir);
            } else if (!files[i].delete()) {
                throw new IOException("Could not delete: " + files[i].getAbsolutePath());
            }
            ++i;
        }
        if (!rootDir.delete()) {
            throw new IOException("Could not delete: " + rootDir.getAbsolutePath());
        }
    }
}

