/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.TagUtil;

public class JspTagUtil
extends TagUtil {
    public static Object findValue(PageContext pageContext, String value, String scope) throws JspException {
        if (value == null) {
            return "";
        }
        if (value.length() < 3) {
            return value;
        }
        String topKey = value.substring(0, 1);
        String stKakko = value.substring(1, 2);
        String edKakko = value.substring(value.length() - 1, value.length());
        if (!topKey.equals("$")) {
            return value;
        }
        StringTokenizer propertySt = new StringTokenizer(value, ".");
        String name = propertySt.nextToken().trim();
        name = name.substring(2, name.length());
        String property = null;
        if (propertySt.hasMoreTokens()) {
            property = propertySt.nextToken().trim();
            property = property.substring(0, property.length() - 1);
        } else {
            name = name.substring(0, name.length() - 1);
        }
        Object result = JspTagUtil.findProperty(pageContext, name, property, scope);
        if (result == null) {
            return "";
        }
        return result;
    }

    public static Object findObject(PageContext pageContext, String name, String scope) {
        Object obj = JspTagUtil.lookup(pageContext, name, scope);
        return obj;
    }

    public static Object findProperty(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object pObj = null;
        Object obj = null;
        if (name != null && name.length() != 0) {
            obj = JspTagUtil.lookup(pageContext, name, scope);
        }
        if (obj != null && property != null) {
            pObj = obj instanceof GeneralForm ? ((GeneralForm)obj).getParameter(property) : (obj instanceof Map ? ((Map)obj).get(property) : (obj instanceof Hashtable ? ((Hashtable)obj).get(property) : BeanUtil.getProperty(obj, property)));
        } else if (obj == null && property != null) {
            pObj = JspTagUtil.lookup(pageContext, property, scope);
        } else if (obj != null && property == null) {
            pObj = obj;
        }
        if (pObj == null) {
            pObj = new String("");
        }
        return pObj;
    }

    public static String findScope(PageContext pageContext, String name) {
        Object obj = null;
        obj = pageContext.getAttribute(name);
        if (obj != null) {
            return "page";
        }
        obj = pageContext.getRequest().getAttribute(name);
        if (obj != null) {
            return "request";
        }
        obj = pageContext.getSession().getAttribute(name);
        if (obj != null) {
            return "session";
        }
        obj = pageContext.getServletContext().getAttribute(name);
        if (obj != null) {
            return "application";
        }
        return null;
    }

    protected static Object lookup(PageContext pageContext, String name, String scope) {
        Object obj = null;
        if (scope == null) {
            obj = JspTagUtil.lookup(pageContext, name);
            return obj;
        }
        if (scope.equals("application")) {
            obj = pageContext.getServletContext().getAttribute(name);
        } else if (scope.equals("session")) {
            obj = pageContext.getSession().getAttribute(name);
        } else if (scope.equals("request")) {
            obj = pageContext.getRequest().getAttribute(name);
        } else if (scope.equals("page")) {
            obj = pageContext.getAttribute(name);
        }
        return obj;
    }

    protected static Object lookup(PageContext pageContext, String name) {
        Object obj = null;
        obj = pageContext.getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = pageContext.getRequest().getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = pageContext.getSession().getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = pageContext.getServletContext().getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = pageContext.getServletContext().getAttribute(name);
        if (obj != null) {
            return obj;
        }
        return obj;
    }

    public static String createAttribute(PageContext pageContext, String name, String property, String scope, String key, String value) throws JspException {
        StringBuffer inputTag = new StringBuffer();
        if (property == null || property.length() == 0) {
            inputTag.append("");
        } else {
            Object result = JspTagUtil.findProperty(pageContext, name, property, scope);
            if (value != null && value.toString().length() > 0) {
                value = JspTagUtil.findValue(pageContext, value, scope).toString();
                inputTag.append(" " + key + "=\"").append(value).append("\" ");
            } else if (result == null || result.toString().length() == 0) {
                result = (String)pageContext.getRequest().getAttribute(property);
                if (result != null && result.toString().length() > 0) {
                    inputTag.append(" " + key + "=\"").append(result).append("\" ");
                } else {
                    inputTag.append("");
                }
            } else {
                inputTag.append(" " + key + "=\"").append(result).append("\" ");
            }
        }
        return inputTag.toString();
    }

    public static String createAttribute(String tagName, String tagValue) {
        StringBuffer inputTag = new StringBuffer(" ").append(tagName);
        inputTag.append("=\"");
        inputTag.append(tagValue).append("\" ");
        if (tagName == null || tagName.length() == 0 || tagValue == null || tagValue.length() == 0) {
            return "";
        }
        return inputTag.toString();
    }

    public static String createBoolAttribute(String tagName, String tagValue) {
        StringBuffer inputTag = new StringBuffer(" ").append(tagName);
        if (tagName == null || tagName.length() == 0 || tagValue == null) {
            return "";
        }
        if (tagValue.toLowerCase().equals("true")) {
            inputTag.append(JspTagUtil.createAttribute(tagName, "true"));
            return inputTag.toString();
        }
        inputTag.append(JspTagUtil.createAttribute(tagName, "false"));
        return inputTag.toString();
    }

    public static String createQueryString(PageContext pageContext, String properties, String scope) throws JspException {
        if (properties == null || properties.length() == 0) {
            return "";
        }
        StringTokenizer dataSt = new StringTokenizer(properties, ",");
        StringBuffer sb = new StringBuffer("");
        if (dataSt.hasMoreTokens()) {
            sb.append("?");
        }
        while (dataSt.hasMoreTokens()) {
            String data = dataSt.nextToken().trim();
            StringTokenizer propertySt = new StringTokenizer(data, ":");
            String name = propertySt.nextToken();
            if (name == null) {
                throw new RuntimeException("name is null query=" + properties);
            }
            name = name.trim();
            String property = null;
            if (propertySt.hasMoreTokens()) {
                property = propertySt.nextToken();
            }
            String htmlName = null;
            if (propertySt.hasMoreTokens()) {
                htmlName = propertySt.nextToken().trim();
            }
            Object value = null;
            if (property == null) {
                value = JspTagUtil.findObject(pageContext, name, scope);
            } else {
                property = property.trim();
                value = JspTagUtil.findProperty(pageContext, name, property, scope);
            }
            if (htmlName != null) {
                sb.append(htmlName).append("=");
            } else if (property == null) {
                sb.append(name).append("=");
            } else {
                sb.append(property).append("=");
            }
            if (value != null) {
                sb.append(value.toString());
            }
            if (!dataSt.hasMoreTokens()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static String createRealPath(PageContext pageContext, String path) {
        if (path == null) {
            path = "/";
        } else if (path.indexOf("/") != 0) {
            path = String.valueOf(path) + "/";
        }
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String realPath = req.getContextPath();
        return String.valueOf(realPath) + path;
    }
}

