/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.itscool.commons.util.NumberFormatUtil;

public class DateFormatUtil {
    private static final int[] DAY_OF_KIND = new int[]{4, 6, 9, 11};

    public static int getMaxDay(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (month == 2) {
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                return 29;
            }
            return 28;
        }
        int i = 0;
        while (i < DAY_OF_KIND.length) {
            if (DAY_OF_KIND[i] == month) {
                return 30;
            }
            ++i;
        }
        return 31;
    }

    public static Calendar getLastMonthWeek(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        int firstYobi = cal.get(7);
        cal.add(5, -(firstYobi - 1));
        return cal;
    }

    public static String encodeYYMMDDString() {
        Calendar cal = Calendar.getInstance();
        return DateFormatUtil.encodeYYMMDDString(cal);
    }

    public static String encodeYYMMDDString(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        String ret = String.valueOf(yearStr) + "/" + monthStr + "/" + dayStr;
        return ret;
    }

    public static String encodeYYYYMMDDString() {
        Calendar cal = Calendar.getInstance();
        return DateFormatUtil.encodeYYYYMMDDString(cal);
    }

    public static String encodeYYYYMMDDString(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String yearStr = String.valueOf(year);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        String ret = String.valueOf(yearStr) + "/" + monthStr + "/" + dayStr;
        return ret;
    }

    public static Calendar decodeYYYYMMDDString(String yyyymmdd) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        try {
            StringTokenizer dataSt = new StringTokenizer(yyyymmdd, "/");
            dataSt.hasMoreTokens();
            int year = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int month = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int day = Integer.parseInt(dataSt.nextToken());
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            return cal;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isCalendar(String str) {
        Calendar cal = DateFormatUtil.decodeYYYYMMDDString(str);
        return cal != null;
    }
}

