/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.threadpool;

import java.util.Vector;
import org.itscool.commons.threadpool.ClosedException;
import org.itscool.commons.threadpool.ThreadBufferException;
import org.itscool.commons.threadpool.WorkerThread;

public class FIFOQueue {
    private Vector requestVector;
    private boolean closed = false;
    public static final int DEFAULT_BUFFER_SIZE = 100;
    private int bufferSize = 100;

    public FIFOQueue() {
        this(100);
    }

    public FIFOQueue(int bufferSize) {
        this.bufferSize = bufferSize;
        this.requestVector = new Vector(bufferSize);
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public synchronized boolean requestEmpty() {
        return this.requestVector.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Object r) throws ClosedException, ThreadBufferException {
        if (this.closed) {
            throw new ClosedException("Queue closed .... ");
        }
        if (this.requestVector.size() > this.bufferSize) {
            throw new ThreadBufferException("buffer size[" + this.requestVector.size() + "] buffer full");
        }
        Vector vector = this.requestVector;
        synchronized (vector) {
            this.requestVector.addElement(r);
            this.requestVector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object fetch(WorkerThread thread) {
        Vector vector = this.requestVector;
        synchronized (vector) {
            while (true) {
                if (this.requestVector.size() != 0) {
                    Object tmp = this.requestVector.elementAt(0);
                    this.requestVector.removeElementAt(0);
                    return tmp;
                }
                try {
                    thread.setWaitStatus();
                    this.requestVector.wait();
                    thread.unsetWaitStatus();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void close() {
        this.closed = true;
    }
}

