/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractLog {
    public static final String DEBUG = "debug";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    public static final String DISP_MODE = "disp";
    public static final String FILE_MODE = "file";
    public static final String ALLOUT_MODE = "all";
    protected boolean init;
    protected int maxSize;
    protected String logPath;
    protected String level = "warn";
    protected int levelInt = 2;
    protected String mode = "disp";
    protected String encode;
    protected List outputClasses = new ArrayList();

    public void setOutputClasses(List outputClasses) {
        this.outputClasses = outputClasses;
    }

    public List getOutputClasses() {
        return this.outputClasses;
    }

    public String getLevel() {
        return this.level;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getMode() {
        return this.mode;
    }

    public abstract void debug(String var1);

    public abstract void info(String var1);

    public abstract void warn(String var1);

    public abstract void error(String var1);

    public abstract void fatal(String var1);

    public abstract void debug(Exception var1);

    public abstract void info(Exception var1);

    public abstract void warn(Exception var1);

    public abstract void error(Exception var1);

    public abstract void fatal(Exception var1);

    public abstract void debug(Error var1);

    public abstract void info(Error var1);

    public abstract void warn(Error var1);

    public abstract void error(Error var1);

    public abstract void fatal(Error var1);

    protected abstract void out(String var1, String var2, int var3);

    protected abstract void out(Exception var1, String var2);

    protected abstract void out(Error var1, String var2);

    public static String getLogKind(String levelNow) {
        if (levelNow.equals(DEBUG)) {
            return "DEBUG";
        }
        if (levelNow.equals(INFO)) {
            return "INFO ";
        }
        if (levelNow.equals(WARN)) {
            return "WORN ";
        }
        if (levelNow.equals(ERROR)) {
            return "ERROR";
        }
        if (levelNow.equals(FATAL)) {
            return "SYSTEM";
        }
        return "DEBUG";
    }

    public static String getLogMode(String mode) {
        if (mode.equals(DISP_MODE)) {
            return "DISP ONLY";
        }
        if (mode.equals(FILE_MODE)) {
            return "FILE ONLY";
        }
        return "DISP & FILE ";
    }

    protected static String getNowDate() {
        Calendar date = Calendar.getInstance();
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = date.get(11);
        int minute = date.get(12);
        int second = date.get(13);
        String monthPadding = "";
        String dayPadding = "";
        String hourPadding = "";
        String minutePadding = "";
        String secondPadding = "";
        if (month < 10) {
            monthPadding = "0";
        }
        if (day < 10) {
            dayPadding = "0";
        }
        if (hour < 10) {
            hourPadding = "0";
        }
        if (minute < 10) {
            minutePadding = "0";
        }
        if (second < 10) {
            secondPadding = "0";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(year).append("/");
        ret.append(monthPadding).append(month).append("/");
        ret.append(dayPadding).append(day).append(" ");
        ret.append(hourPadding).append(hour).append(":");
        ret.append(minutePadding).append(minute).append(":");
        ret.append(secondPadding).append(second);
        return ret.toString();
    }

    protected static String getNowDateYYYYMMDDHHMMSS() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        String month = String.valueOf(date.get(2));
        String day = String.valueOf(date.get(5));
        String hour = String.valueOf(date.get(10));
        String minute = String.valueOf(date.get(12));
        String second = String.valueOf(date.get(13));
        return String.valueOf(year) + month + day + hour + minute + second;
    }

    protected synchronized void sizeCheck() {
        File file = new File(this.logPath);
        if (file.canRead() && file.length() >= (long)(this.maxSize * 1024)) {
            file.renameTo(new File(String.valueOf(this.logPath) + "." + AbstractLog.getNowDateYYYYMMDDHHMMSS()));
        }
        file = null;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void setLevel(String level) {
        this.level = level;
        this.levelInt = this.getLevelNum(level);
    }

    protected int getLevelNum(String level) {
        this.level = level;
        if (level.equals(DEBUG)) {
            return 0;
        }
        if (level.equals(INFO)) {
            return 1;
        }
        if (level.equals(WARN)) {
            return 2;
        }
        if (level.equals(ERROR)) {
            return 3;
        }
        if (level.equals(FATAL)) {
            return 4;
        }
        return 0;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

