/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.itscool.commons.document.DocumentBean;
import org.itscool.commons.document.DocumentBeanParser;

public class BeanToJsonDocument {
    private String LINE = System.getProperty("line.separator");
    private ArrayList pBeanList = new ArrayList();
    private String rootName;

    public BeanToJsonDocument(String rootName) {
        this.rootName = rootName;
    }

    public void addElement(Object bean) throws Exception {
        DocumentBean pBean = DocumentBeanParser.parseBean(bean);
        this.addElement(pBean);
    }

    public void addElement(List list) throws Exception {
        int i = 0;
        while (i < list.size()) {
            Object bean = list.get(i);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            this.addElement(pBean);
            ++i;
        }
    }

    public void addElement(Map map) throws Exception {
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object bean = map.get(key);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean);
            this.addElement(pBean);
        }
    }

    protected void addElement(DocumentBean pBean) throws Exception {
        this.pBeanList.add(pBean);
    }

    public String parseText() {
        StringBuffer sb = new StringBuffer("{\"" + this.rootName + "\":[");
        int size = this.pBeanList.size();
        int i = 0;
        while (i < size) {
            DocumentBean dBean = (DocumentBean)this.pBeanList.get(i);
            sb.append("{");
            Set set = dBean.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String value;
                String name = (String)it.next();
                Object object = dBean.getValue(name);
                if (object instanceof DocumentBean) {
                    value = this.parseText((DocumentBean)object, name);
                    sb.append(value);
                } else {
                    value = (String)dBean.getValue(name);
                    sb.append("\"" + name + "\":");
                    sb.append("\"" + value + "\"");
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            if (i + 1 < size) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]}");
        return sb.toString();
    }

    public String parseText(DocumentBean dBean, String parentName) {
        StringBuffer sb = new StringBuffer("{\"" + parentName + "\":[");
        int size = this.pBeanList.size();
        sb.append("{");
        Set set = dBean.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object object = dBean.getValue(name);
            if (object instanceof DocumentBean) {
                sb.append(this.parseText((DocumentBean)object, name));
            } else {
                String value = (String)dBean.getValue(name);
                sb.append("\"" + name + "\":");
                sb.append("\"" + value + "\"");
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

