/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.io.IOException;
import java.util.HashMap;
import org.itscool.commons.dao.DaoInfo;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;
import org.itscool.commons.document.XmlConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DaoConfigReader
extends XmlConfigReader {
    protected void doCreate(HashMap hashMap) throws IOException {
        Node roles;
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at weber-message.xml(" + this.getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList rolesList = root.getElementsByTagName("beans");
        if (rolesList != null && (roles = rolesList.item(0)) != null) {
            this.createDaos(roles, hashMap);
        }
    }

    protected void createDaos(Node roles, HashMap hashMap) {
        NodeList rolesChilds = roles.getChildNodes();
        int i = 0;
        while (i < rolesChilds.getLength()) {
            Node message = rolesChilds.item(i);
            if (message.getNodeName().equals("bean")) {
                this.createDao(message, hashMap);
            }
            ++i;
        }
    }

    protected void createDao(Node message, HashMap hashMap) {
        NamedNodeMap attributes = message.getAttributes();
        Node name = attributes.getNamedItem("name");
        String entity = name.getNodeValue();
        RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
        HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
        DaoInfo daoInfo = new DaoInfo();
        daoInfo.setGRecordMap(gRecordMap);
        daoInfo.setFkRecordMaps(fkRecordMaps);
        hashMap.put(entity, daoInfo);
    }
}

