/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.bean;

import java.io.IOException;
import java.util.HashMap;
import org.itscool.commons.bean.BeanInfoMapping;
import org.itscool.commons.bean.BeanPropertyInfo;
import org.itscool.commons.document.XmlConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanConfigReader
extends XmlConfigReader {
    protected void doCreate(HashMap hashMap) throws IOException {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at di-config.xml(" + this.getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList mappingsList = root.getElementsByTagName("bean-mappings");
        if (mappingsList == null) {
            String err = "Can not element at <bean-maggpins>(" + this.getClass().getName() + ")";
            throw new IOException(err);
        }
        Node mappings = mappingsList.item(0);
        if (mappings != null) {
            this.createMappings(mappings, hashMap);
        }
    }

    protected void createMappings(Node mappings, HashMap hashMap) throws IOException {
        NodeList mappingsChilds = mappings.getChildNodes();
        int i = 0;
        while (i < mappingsChilds.getLength()) {
            Node beanInfoNode = mappingsChilds.item(i);
            if (beanInfoNode.getNodeName().equals("bean")) {
                this.createBeanInfo(beanInfoNode, hashMap);
            }
            ++i;
        }
    }

    protected void createBeanInfo(Node beanInfoNode, HashMap hashMap) throws IOException {
        NamedNodeMap attributes = beanInfoNode.getAttributes();
        Node id = attributes.getNamedItem("id");
        Node type = attributes.getNamedItem("type");
        Node singleton = attributes.getNamedItem("singleton");
        Node value = attributes.getNamedItem("value");
        if (id == null || id.getNodeName().length() == 0) {
            throw new IOException("bean tag's id is null");
        }
        String typeStr = type == null || type.getNodeName().length() == 0 ? "java.lang.String" : type.getNodeValue();
        BeanInfoMapping beanMapping = new BeanInfoMapping(id.getNodeValue(), typeStr);
        if (value != null && value.getNodeName().length() > 0) {
            String valueStr = value.getNodeValue();
            beanMapping.setValue(valueStr);
        }
        if (singleton != null && singleton.getNodeName().length() > 0) {
            boolean ret = new Boolean(singleton.getNodeValue());
            beanMapping.setSingleton(ret);
        }
        NodeList childs = beanInfoNode.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals("property")) {
                this.createProerty(child, beanMapping);
            }
            ++i;
        }
        hashMap.put(beanMapping.getId(), beanMapping);
    }

    protected void createProerty(Node propertyNode, BeanInfoMapping beanMapping) throws IOException {
        NamedNodeMap attributes = propertyNode.getAttributes();
        Node name = attributes.getNamedItem("name");
        Node value = attributes.getNamedItem("value");
        Node ref = attributes.getNamedItem("ref");
        Node collection = attributes.getNamedItem("collection");
        if (name == null || name.getNodeName().length() == 0) {
            throw new IOException("property tag's name is null.");
        }
        BeanPropertyInfo property = new BeanPropertyInfo();
        property.setName(name.getNodeValue());
        if (value != null) {
            property.setValue(value.getNodeValue());
        } else if (ref != null) {
            property.setRef(ref.getNodeValue());
        } else if (collection != null) {
            property.setCollection(collection.getNodeValue());
            this.createMappings(propertyNode, property.getAttrList());
        }
        beanMapping.addProperty(name.getNodeValue(), property);
    }
}

