/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.util.ServletTagUtil;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.tag.HtmlAttribute;
import org.itscool.stylist.tag.HtmlTag;

public class HtmlAttributeConverter
extends HtmlConverter {
    public HtmlAttributeConverter(ServletContext context, HttpServletRequest req) {
        super(context, req);
    }

    public String convert(HtmlTag node) {
        Object object;
        String property;
        String value;
        StringBuffer sb = new StringBuffer();
        ArrayList attrList = node.getAttributeList();
        int size = attrList.size();
        int i = 0;
        while (i < size) {
            HtmlAttribute attr = (HtmlAttribute)attrList.get(i);
            String attrName = attr.getName();
            sb.append(" ").append(attrName);
            sb.append("=");
            sb.append("\"");
            value = attr.getValue();
            if (attr.getName().equals("action") || attr.getName().equals("href") || attr.getName().equals("src") || attr.getName().equals("background")) {
                value = this.convertRealPath(value);
            }
            ArrayList tagList = HtmlAttributeConverter.parseEl(value);
            sb.append(this.parseText(tagList));
            sb.append("\"");
            ++i;
        }
        if (this.isCheckbox(node)) {
            String name = node.getAttribute("w_name");
            object = ServletTagUtil.findProperty((ServletContext)this.context, (HttpServletRequest)this.req, (String)name, (String)(property = node.getAttribute("w_property")), null);
            if (TagUtil.isCheckedValue((Object)object, (String)(value = node.getAttribute("value")))) {
                sb.append(" checked=\"true\"");
            }
        } else if (this.isOption(node)) {
            if (this.isParentSelect(node)) {
                String value2;
                String property2;
                HtmlTag parent = node.getParent();
                String name = parent.getAttribute("w_name");
                Object object2 = ServletTagUtil.findProperty((ServletContext)this.context, (HttpServletRequest)this.req, (String)name, (String)(property2 = parent.getAttribute("w_property")), null);
                if (TagUtil.isCheckedValue((Object)object2, (String)(value2 = node.getAttribute("value")))) {
                    sb.append(" selected=\"true\"");
                }
            } else {
                String name = node.getAttribute("w_name");
                object = ServletTagUtil.findProperty((ServletContext)this.context, (HttpServletRequest)this.req, (String)name, (String)(property = node.getAttribute("w_property")), null);
                if (TagUtil.isCheckedValue((Object)object, (String)(value = node.getAttribute("value")))) {
                    sb.append(" selected=\"true\"");
                }
            }
        }
        return sb.toString();
    }

    protected boolean isCheckbox(HtmlTag node) {
        if (!node.getTagName().toLowerCase().equals("input")) {
            return false;
        }
        HtmlAttribute type = node.getHtmlAttribute("type");
        if (type == null) {
            return false;
        }
        String checkbox = type.getValue();
        return checkbox.toLowerCase().equals("checkbox") || checkbox.toLowerCase().equals("radio");
    }

    protected boolean isOption(HtmlTag node) {
        return node.getTagName().toLowerCase().equals("option");
    }

    protected boolean isParentSelect(HtmlTag node) {
        HtmlTag parent = node.getParent();
        return parent.getTagName().toLowerCase().equals("select");
    }

    public String convertRealPath(String pUrl) {
        String contextPath = this.req.getContextPath();
        String realPath = "";
        String url = pUrl;
        int firstIndex = url.indexOf("./");
        if (firstIndex == 0) {
            url = url.substring(firstIndex + 2);
            int index = url.indexOf("../");
            List pathList = this.getPathList();
            int listNum = pathList.size();
            String pathListStr = "/";
            if (listNum >= 3) {
                int i = 0;
                while (index == 0 || i + 3 < listNum) {
                    url = url.substring(index + 2);
                    pathListStr = String.valueOf(pathListStr) + (String)pathList.get(listNum - (i + 3));
                    index = url.indexOf("../");
                    if (index == 0) {
                        pathListStr = String.valueOf(pathListStr) + "/";
                    }
                    ++i;
                }
                realPath = String.valueOf(contextPath) + pathListStr + url;
            } else {
                realPath = pUrl;
            }
        } else {
            return pUrl;
        }
        return realPath;
    }

    public List getPathList() {
        String sPath = this.req.getServletPath();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sPath, "/");
        while (st.hasMoreTokens()) {
            String name = (String)st.nextElement();
            list.add(name);
        }
        return list;
    }
}

