/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.InitParamMap;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.CustomPageResponseWrapper;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.io.LayoutConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.itscool.stylist.tag.LayoutRegex;

public class LayoutFilter
implements Filter {
    protected FilterConfig filterConfig = null;
    protected ServletContext context = null;
    private AbstractLog log;

    public void init(FilterConfig config) throws ServletException {
        if (this.filterConfig == null) {
            this.filterConfig = config;
        }
        if (this.filterConfig == null) {
            this.filterConfig = config;
        }
        this.context = this.filterConfig.getServletContext();
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        try {
            this.log = (AbstractLog)factory.getInstance("Log");
            if (!this.log.isInit()) {
                this.log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            this.log = SimpleLog.getInstance();
            this.log.info(ioe.getMessage());
        }
        LayoutMappings includeMappings = LayoutMappings.getInstance();
        try {
            InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
            String stylistConf = params.getParam("stylist-config");
            LayoutConfigReader includeReader = new LayoutConfigReader();
            includeReader.setConfigName(stylistConf);
            includeReader.create(includeMappings);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        CustomPageResponseWrapper wrapper = new CustomPageResponseWrapper(res);
        chain.doFilter((ServletRequest)req, (ServletResponse)wrapper);
        res.reset();
        try {
            String path = req.getServletPath();
            String jsp = this.layout(path, req, res, chain);
            this.doLayout(chain, req, res, wrapper, jsp);
        }
        catch (Exception e) {
            this.log.error(e);
            throw new ServletException(e.getMessage());
        }
        catch (Error e) {
            this.log.error(e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doLayout(FilterChain chain, HttpServletRequest req, HttpServletResponse res, CustomPageResponseWrapper wrapper, String jsp) throws IOException, ServletException {
        InitParamMap params = InitParamMap.getInstance();
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        byte[] buff = wrapper.getByteStream().toByteArray();
        String buffStr = new String(buff);
        LayoutRegex regex = new LayoutRegex(this.context, req);
        buffStr = regex.replacePath(buffStr);
        buffStr = regex.replaceEl(buffStr);
        if (wrapper.getContentType() != null) {
            res.setContentType(wrapper.getContentType());
        } else if (buffStr.indexOf("<?xml") >= 0) {
            res.setContentType("text/xml; charset=" + encode);
        } else {
            res.setContentType("text/html; charset=" + encode);
        }
        if (jsp == null) {
            PrintWriter writer = res.getWriter();
            writer.write(buffStr);
            writer.flush();
            writer.close();
            return;
        }
        TagInfo body = TagUtil.createTagInfo((String)buffStr, (String)"body");
        TagInfo head = TagUtil.createTagInfo((String)buffStr, (String)"head");
        if (body != null) {
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)body.getDataInTag());
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body_tag", (Object)body.getStartTag());
            if (head != null) {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.head", (Object)head.getDataInTag());
            }
        } else {
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)buffStr);
        }
        this.filterConfig.getServletContext().getRequestDispatcher(jsp).forward((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }

    protected String layout(String path, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        LayoutMappings mappings = LayoutMappings.getInstance();
        LayoutMapping include = (LayoutMapping)mappings.get(path);
        if (include == null) {
            return null;
        }
        String extendz = include.getExtendz();
        if (extendz != null) {
            this.checkParentLayout(include, req, res, chain);
        }
        String layoutPath = include.getPath();
        HashMap putMap = include.getPuts();
        if (putMap != null) {
            Set keySet = putMap.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
                this.setIncludeContents(put, name, req, res, chain);
            }
        }
        return layoutPath;
    }

    protected void checkParentLayout(LayoutMapping layout, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        HashMap putMap;
        LayoutMappings mappings = LayoutMappings.getInstance();
        String parentName = layout.getExtendz();
        String extendz = layout.getExtendz();
        if (extendz != null) {
            LayoutMapping parent = (LayoutMapping)mappings.get(parentName);
            this.checkParentLayout(parent, req, res, chain);
        }
        if ((putMap = layout.getPuts()) == null) {
            return;
        }
        Set keySet = putMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
            this.setIncludeContents(put, name, req, res, chain);
        }
    }

    protected void setIncludeContents(LayoutPutMapping put, String attrName, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        CustomPageResponseWrapper wrapper = new CustomPageResponseWrapper(res);
        RequestDispatcher rd = req.getRequestDispatcher(put.getPath());
        rd.forward((ServletRequest)req, (ServletResponse)wrapper);
        byte[] buff = wrapper.getByteStream().toByteArray();
        String buffStr = new String(buff);
        TagInfo body = TagUtil.createTagInfo((String)buffStr, (String)"body");
        if (body != null && body.getDataInTag() != null) {
            buffStr = body.getDataInTag();
        }
        LayoutRegex regex = new LayoutRegex(this.context, req);
        buffStr = regex.replacePath(buffStr);
        buffStr = regex.replaceEl(buffStr);
        req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)buffStr);
    }
}

