/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import junit.framework.TestCase;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.action.Action;
import org.itscool.weber.testcase.MockActionBucket;
import org.itscool.weber.testcase.MockGeneralForm;
import org.itscool.weber.user.User;

public abstract class WeberTestCase
extends TestCase {
    protected BeanFactory factory = BeanFactory.getInstance();
    protected MockActionBucket bucket = new MockActionBucket();
    protected MockGeneralForm request = new MockGeneralForm();
    protected static AbstractLog log = SimpleLog.getInstance();

    static {
        BeanFactory factory = BeanFactory.getInstance();
        try {
            if (!log.isInit()) {
                log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void assertDoExecute(Action action, Object form, String forward) {
        this.bucket.setForm(form);
        action.setGeneralForm(this.request);
        String result = "";
        try {
            result = action.doExecute(this.bucket);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
        WeberTestCase.assertEquals((String)forward, (String)result);
    }

    public void assertCheckUserRole(Action action, User user, boolean ret) {
        action.setGeneralForm(this.request);
        this.bucket.setAttributeFromSession("org_itscool_weber_action_USER", user);
        try {
            boolean isUser = action.checkUserRole(this.bucket);
            WeberTestCase.assertEquals((boolean)ret, (boolean)isUser);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
    }

    public void assertValidate(Action action, String forward) {
        action.setGeneralForm(this.request);
        try {
            String ret = action.validate(this.bucket);
            WeberTestCase.assertEquals((String)forward, (String)ret);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            WeberTestCase.fail((String)e.getMessage());
        }
    }
}

