/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webalone.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import jp.sourceforge.webalone.IConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;

public class PropertiesConfiguration
implements IConfiguration {
    private static final Log LOG = LogFactory.getLog(PropertiesConfiguration.class);
    private static final String CONFIG_PROPERTIES = "webalone.properties";
    private static final String PROP_SHUTDOWN_TIME = "webalone.shutdown";
    private static final String PROP_WEBAPP_PATH = "webalone.webapp";
    private static final String PROP_PORT = "webalone.port";
    private static final String PROP_BROWSER = "webalone.browser";
    private static final String SHUTDOWN_CONTEXT = "__webalone__";
    private static final String SHUTDOWN_SERVLET = "/shutdown";
    private static final long DEFAULT_SHUTDOWN_TIME = 15L;
    private static final int DEFAULT_PORT = 12345;
    private static final String DEFAULT_WEBAPP_PATH = "webapp";
    private long fShutdownTime;
    private int fPort;
    private String fWebappPath;
    private String fBrowserCommand;

    public PropertiesConfiguration() {
        block6: {
            this.fBrowserCommand = null;
            try {
                Properties props = this.loadProperties();
                this.fShutdownTime = Long.parseLong(props.getProperty(PROP_SHUTDOWN_TIME, Long.toString(15L)));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("shutdown time: " + this.fShutdownTime + " min"));
                }
                this.fPort = Integer.parseInt(props.getProperty(PROP_PORT, Integer.toString(12345)));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("port: " + this.fPort));
                }
                this.fWebappPath = props.getProperty(PROP_WEBAPP_PATH, DEFAULT_WEBAPP_PATH);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("web application: " + this.fWebappPath));
                }
                this.fBrowserCommand = props.getProperty(PROP_BROWSER);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("custom browser command: " + this.fBrowserCommand));
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"cannot load configuration properties.", (Throwable)e);
            }
        }
        this.validate();
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        File propFile = new File(CONFIG_PROPERTIES);
        if (propFile.isFile()) {
            props.load(new FileInputStream(propFile));
            return props;
        }
        props.load(PropertiesConfiguration.class.getClassLoader().getResourceAsStream(CONFIG_PROPERTIES));
        return props;
    }

    public void validate() {
        if (!PropertiesConfiguration.isDirectoryOrWar(this.fWebappPath)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("!!!WRONG CONFIGURATION!!! webapp is not directory nor war file: " + this.fWebappPath));
            }
            throw new RuntimeException("webapp directory not found: " + this.fWebappPath);
        }
    }

    private static boolean isDirectoryOrWar(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return true;
        }
        return file.isFile() && path.endsWith(".war");
    }

    public Server createServer() {
        Server server = new Server();
        try {
            server.setStatsOn(true);
            server.addListener(new InetAddrPort(this.fPort));
            if (this.fWebappPath != null) {
                server.addWebApplication("/", this.fWebappPath);
            }
            PropertiesConfiguration.addShutdownContext(server);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("registered contexts: " + Arrays.asList(server.getContexts())));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return server;
    }

    private static void addShutdownContext(Server server) {
        HttpContext context = new HttpContext((HttpServer)server, SHUTDOWN_CONTEXT);
        ServletHandler handler = new ServletHandler();
        handler.addServlet(SHUTDOWN_SERVLET, "jp.sourceforge.webalone.ShutdownServlet");
        context.addHandler((HttpHandler)handler);
    }

    public String getShutdownURL() {
        return String.valueOf(this.getApplicationURL()) + SHUTDOWN_CONTEXT + SHUTDOWN_SERVLET + "?shutdown=true";
    }

    public long getShutdownTime() {
        return this.fShutdownTime * 60L * 1000L;
    }

    public String getApplicationURL() {
        return "http://localhost:" + this.fPort + "/";
    }

    public boolean isBrowserCommandSet() {
        return this.fBrowserCommand != null;
    }

    public String getBrowserCommand() {
        return this.fBrowserCommand;
    }
}

