/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webalone;

import com.meterware.httpunit.WebConversation;
import javax.swing.JFrame;
import jp.sourceforge.webalone.BrowserLauncher;
import jp.sourceforge.webalone.ConfigurationFactory;
import jp.sourceforge.webalone.IConfiguration;
import jp.sourceforge.webalone.ShutdownServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Server;

public class Starter {
    private static final Log LOG = LogFactory.getLog(Starter.class);
    private final IConfiguration fConfiguration = ConfigurationFactory.createConfiguration();
    private final long fShutdownTime = this.fConfiguration.getShutdownTime();
    private Server fJettyServer;
    private boolean fConnected = false;
    private long fLastDisconnectedTime = System.currentTimeMillis();

    public static void main(String[] args) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"===[ start ]=======================================================================");
        }
        final JFrame dummyWindow = new JFrame();
        dummyWindow.setVisible(true);
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"close dummy window.");
                }
                dummyWindow.setVisible(false);
            }
        }.start();
        try {
            Starter starter = new Starter();
            starter.start();
        }
        finally {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"===[ end ]=========================================================================");
            }
            System.exit(0);
        }
    }

    public void start() {
        try {
            try {
                this.doStart();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"application started.");
                }
                this.launchBrowser();
                while (this.checkActive()) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.fJettyServer == null) {
                return;
            }
            try {
                this.fJettyServer.stop(true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"application shutdown.");
            }
        }
    }

    private void doStart() throws Exception {
        this.fJettyServer = this.fConfiguration.createServer();
        try {
            this.fJettyServer.start();
            return;
        }
        catch (Exception e) {
            this.sendShutdownMessage();
            this.fJettyServer.destroy();
            Thread.sleep(1000L);
            this.fJettyServer = this.fConfiguration.createServer();
            this.fJettyServer.start();
            return;
        }
    }

    private void sendShutdownMessage() throws Exception {
        WebConversation conversation = new WebConversation();
        conversation.getResponse(this.fConfiguration.getShutdownURL());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"shutdown another server.");
        }
    }

    private boolean checkActive() {
        boolean connected;
        ShutdownServlet servlet = ShutdownServlet.getInstance();
        if (servlet != null && servlet.isShutdown()) {
            return false;
        }
        boolean bl = connected = this.fJettyServer.getConnectionsOpen() > 0;
        if (connected) {
            if (!this.fConnected && LOG.isDebugEnabled()) {
                LOG.debug((Object)"connected.");
            }
        } else if (this.fConnected) {
            this.fLastDisconnectedTime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"disconnected.");
            }
        } else if (System.currentTimeMillis() - this.fLastDisconnectedTime > this.fShutdownTime) {
            return false;
        }
        this.fConnected = connected;
        return true;
    }

    private void launchBrowser() {
        BrowserLauncher launcher = new BrowserLauncher(this.fConfiguration);
        launcher.launch();
    }
}

