/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webalone;

import java.util.Arrays;
import jp.sourceforge.webalone.IConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowserLauncher {
    private static final Log LOG = LogFactory.getLog(BrowserLauncher.class);
    private static final String OS_WINDOWS = "Windows XP";
    private static final String DEFAULT_COMMAND_WINDOWS = "explorer";
    private final IConfiguration fConfiguration;

    public BrowserLauncher(IConfiguration config) {
        this.fConfiguration = config;
    }

    public void launch() {
        block7: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("launch browser: " + this.fConfiguration.getApplicationURL()));
            }
            String os = System.getProperty("os.name");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OS: " + os));
            }
            String[] command = new String[2];
            if (!OS_WINDOWS.equals(os)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)(String.valueOf(os) + " is not supported for now."));
                }
                return;
            }
            command[0] = this.fConfiguration.isBrowserCommandSet() ? this.fConfiguration.getBrowserCommand() : DEFAULT_COMMAND_WINDOWS;
            command[1] = this.fConfiguration.getApplicationURL();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Arrays.asList(command));
            }
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"cannot launch browser.", (Throwable)e);
            }
        }
    }
}

