/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpUnitUtils {
    public static final int DEFAULT_TEXT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_BUFFER_SIZE = 128;
    public static final String DEFAULT_CHARACTER_SET = "iso-8859-1";

    public static String[] parseContentTypeHeader(String header) {
        String[] result = new String[]{"text/plain", null};
        StringTokenizer st = new StringTokenizer(header, ";=");
        result[0] = st.nextToken();
        while (st.hasMoreTokens()) {
            String parameter = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = HttpUnitUtils.stripQuotes(st.nextToken());
            if (!parameter.trim().equalsIgnoreCase("charset")) continue;
            result[1] = value;
        }
        return result;
    }

    public static String stripQuotes(String value) {
        if (value.startsWith("'") || value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("'") || value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String decode(String byteString) {
        return HttpUnitUtils.decode(byteString, DEFAULT_CHARACTER_SET);
    }

    static String trimmedValue(Number number) {
        String rawNumber = number.toString();
        if (rawNumber.indexOf(46) == -1) {
            return rawNumber;
        }
        int index = rawNumber.length();
        while (rawNumber.charAt(index - 1) == '0') {
            --index;
        }
        if (rawNumber.charAt(index - 1) == '.') {
            --index;
        }
        return rawNumber.substring(0, index);
    }

    public static String decode(String string, String charset) {
        try {
            if (string == null) {
                return null;
            }
            return new String(HttpUnitUtils.decodeUrl(string.getBytes("US-ASCII")), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private static final byte[] decodeUrl(byte[] pArray) throws IllegalArgumentException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < pArray.length; ++i) {
            byte b = pArray[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b != 37) {
                buffer.write(b);
                continue;
            }
            try {
                int u = Character.digit((char)pArray[++i], 16);
                int l = Character.digit((char)pArray[++i], 16);
                if (u == -1 || l == -1) {
                    throw new IllegalArgumentException("Invalid URL encoding");
                }
                buffer.write((char)((u << 4) + l));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid URL encoding");
            }
        }
        return buffer.toByteArray();
    }

    public static DocumentBuilder newParser() throws SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClasspathEntityResolver());
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
    }

    static String[] withNewValue(String[] oldValue, String newValue) {
        String[] result;
        if (oldValue == null) {
            result = new String[]{newValue};
        } else {
            result = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static Object[] withNewValue(Object[] oldValue, Object newValue) {
        Object[] result;
        if (oldValue == null) {
            result = new Object[]{newValue};
        } else {
            result = new Object[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static boolean contains(String string, String substring) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().indexOf(substring.toUpperCase()) >= 0;
        }
        return string.indexOf(substring) >= 0;
    }

    static boolean hasPrefix(String string, String prefix) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().startsWith(prefix.toUpperCase());
        }
        return string.startsWith(prefix);
    }

    static boolean matches(String string1, String string2) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string1.equalsIgnoreCase(string2);
        }
        return string1.equals(string2);
    }

    static boolean isJavaScriptURL(String urlString) {
        return urlString.toLowerCase().startsWith("javascript:");
    }

    static String trimAll(String s) {
        if ((s = s.trim()).indexOf(32) < 0) {
            return s;
        }
        boolean inQuotes = false;
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == '\"' || aChar == '\'') {
                inQuotes = !inQuotes;
                sb.append(aChar);
                continue;
            }
            if (!inQuotes && aChar <= ' ') continue;
            sb.append(aChar);
        }
        return sb.toString();
    }

    static String replaceEntities(String string) {
        int ampIndex;
        int i = 0;
        while ((ampIndex = string.indexOf(38, i)) >= 0) {
            String entityName;
            int semiColonIndex = string.indexOf(59, ampIndex + 1);
            if (semiColonIndex < 0 || !(entityName = string.substring(ampIndex + 1, semiColonIndex)).equalsIgnoreCase("amp")) continue;
            string = string.substring(0, ampIndex) + '&' + string.substring(semiColonIndex + 1);
            i = ampIndex + 1;
        }
        return string;
    }

    static String trimFragment(String rawUrl) {
        if (HttpUnitUtils.isJavaScriptURL(rawUrl)) {
            return rawUrl;
        }
        int hashIndex = rawUrl.indexOf(35);
        return hashIndex < 0 ? rawUrl : rawUrl.substring(0, hashIndex);
    }

    static class ClasspathEntityResolver
    implements EntityResolver {
        ClasspathEntityResolver() {
        }

        public InputSource resolveEntity(String publicID, String systemID) {
            if (systemID == null) {
                return null;
            }
            String localName = systemID;
            if (localName.indexOf("/") > 0) {
                localName = localName.substring(localName.lastIndexOf("/") + 1, localName.length());
            }
            try {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream(localName));
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

