/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CSVWriter {
    private PrintWriter writer;
    private boolean firstColumn;

    public CSVWriter() {
    }

    public CSVWriter(String fileName) throws IOException {
        this.open(fileName);
    }

    public CSVWriter(OutputStream os) {
        this.open(os);
    }

    public CSVWriter(Writer w) {
        this.open(w);
    }

    public final void open(String fileName) throws IOException {
        this.writer = new PrintWriter(fileName);
        this.firstColumn = true;
    }

    public final void open(OutputStream os) {
        this.writer = new PrintWriter(os);
        this.firstColumn = true;
    }

    public final void open(Writer w) {
        this.writer = new PrintWriter(w);
        this.firstColumn = true;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(String data) throws IOException {
        if (!this.firstColumn) {
            this.writer.print(",");
        }
        this.firstColumn = false;
        this.writer.print("\"");
        this.writer.print(data);
        this.writer.print("\"");
    }

    public void crlf() throws IOException {
        this.writer.println();
        this.firstColumn = true;
    }
}

