/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.infodb.commons.html.AbstractBody;
import org.infodb.commons.html.Attr;
import org.infodb.commons.html.FIELDSET;
import org.infodb.commons.html.LABEL;

public abstract class AbstractForm
extends AbstractBody {
    public AbstractForm(Writer writer, String elementName, Attr ... attr) throws IOException {
        super(writer, elementName, attr);
    }

    public FIELDSET fieldset(Attr ... attr) throws IOException {
        return new FIELDSET(this.writer, attr);
    }

    public LABEL label(Attr ... attr) throws IOException {
        return new LABEL(this.writer, attr);
    }

    private void input(String type, String name, String value, Attr ... attr) throws IOException {
        this.writer.write("<input type=\"");
        this.writer.write(type);
        this.writer.write("\" name=\"");
        this.writer.write(name);
        this.writer.write("\"");
        if (value != null) {
            this.writer.write(" value=\"");
            this.writer.write(value);
            this.writer.write("\"");
        }
        Attr.output(this.writer, attr);
        this.writer.write(">");
    }

    public void inputHidden(String name, String value) throws IOException {
        this.input("hidden", name, value, new Attr[0]);
    }

    public void inputText(String name, String value, Attr ... attr) throws IOException {
        this.input("text", name, value, attr);
    }

    public void inputSearch(String name, String value, Attr ... attr) throws IOException {
        this.input("search", name, value, attr);
    }

    public void inputTel(String name, String value, Attr ... attr) throws IOException {
        this.input("tel", name, value, attr);
    }

    public void inputUrl(String name, String value, Attr ... attr) throws IOException {
        this.input("url", name, value, attr);
    }

    public void inputEmail(String name, String value, Attr ... attr) throws IOException {
        this.input("email", name, value, new Attr[0]);
    }

    public void inputPassword(String name, String value, Attr ... attr) throws IOException {
        this.input("password", name, value, attr);
    }

    public void inputDateTime(String name, String value, Attr ... attr) throws IOException {
        this.input("datetime", name, value, attr);
    }

    public void inputDate(String name, String value, Attr ... attr) throws IOException {
        this.input("date", name, value, attr);
    }

    public void inputMonth(String name, String value, Attr ... attr) throws IOException {
        this.input("month", name, value, attr);
    }

    public void inputWeek(String name, String value, Attr ... attr) throws IOException {
        this.input("week", name, value, attr);
    }

    public void inputTime(String name, String value, Attr ... attr) throws IOException {
        this.input("time", name, value, attr);
    }

    public void inputDateTimeLocal(String name, String value, Attr ... attr) throws IOException {
        this.input("datetime-local", name, value, attr);
    }

    public void inputNumber(String name, String value, Attr ... attr) throws IOException {
        this.input("number", name, value, attr);
    }

    public void inputRange(String name, String value, Attr ... attr) throws IOException {
        this.input("range", name, value, attr);
    }

    public void inputColor(String name, String value, Attr ... attr) throws IOException {
        this.input("color", name, value, attr);
    }

    public void inputCheckBox(String name, String value, Attr ... attr) throws IOException {
        this.input("checkbox", name, value, attr);
    }

    public void inputRadio(String name, String value, Attr ... attr) throws IOException {
        this.input("radio", name, value, attr);
    }

    public void inputFile(String name, Attr ... attr) throws IOException {
        this.input("file", name, null, attr);
    }

    public void inputSubmit(String name, String value, Attr ... attr) throws IOException {
        this.input("submit", name, value, attr);
    }

    public void inputImage(String name, String src, String alt, String value, Attr ... attr) throws IOException {
    }

    public void button() {
    }

    public void datalist(String id, Collection<?> list) throws IOException {
        this.writer.write("<datalist id=\"");
        this.writer.write(id);
        this.writer.write("\">");
        for (Object data : list) {
            this.writer.write("<option value=\"");
            this.writer.write(data.toString());
            this.writer.write("\">");
        }
        this.writer.write("</datalist>");
    }

    public void textArea(String name, String value, Attr ... attr) throws IOException {
        this.writer.write("<textarea name=\"");
        this.writer.write(name);
        this.writer.write("\"");
        Attr.output(this.writer, attr);
        this.writer.write(">");
        this.writer.write(value);
        this.writer.write("</textarea>");
    }
}

