/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.html;

import java.io.IOException;
import java.io.Writer;
import org.infodb.commons.html.A;
import org.infodb.commons.html.ARTICLE;
import org.infodb.commons.html.Attr;
import org.infodb.commons.html.DIV;
import org.infodb.commons.html.FOOTER;
import org.infodb.commons.html.FORM;
import org.infodb.commons.html.H;
import org.infodb.commons.html.HEADER;
import org.infodb.commons.html.I;
import org.infodb.commons.html.NAV;
import org.infodb.commons.html.OL;
import org.infodb.commons.html.P;
import org.infodb.commons.html.S;
import org.infodb.commons.html.SECTION;
import org.infodb.commons.html.SPAN;
import org.infodb.commons.html.STRONG;
import org.infodb.commons.html.TABLE;
import org.infodb.commons.html.UL;

public abstract class AbstractBody {
    protected Writer writer;
    protected String elementName;

    protected AbstractBody(Writer writer, String elementName, Attr ... attr) throws IOException {
        this.writer = writer;
        this.elementName = elementName;
        writer.write("<");
        writer.write(elementName);
        Attr.output(writer, attr);
        writer.write(">");
    }

    public final void end() throws IOException {
        this.writer.write("</");
        this.writer.write(this.elementName);
        this.writer.write(">");
    }

    public AbstractBody text(String text) throws IOException {
        if (text != null) {
            this.writer.write(text);
        }
        return this;
    }

    public A a(Attr ... attr) throws IOException {
        return new A(this.writer, attr);
    }

    public AbstractBody br() throws IOException {
        this.writer.write("<br/>");
        return this;
    }

    public HEADER header() throws IOException {
        return new HEADER(this.writer, new Attr[0]);
    }

    public ARTICLE article(Attr ... attr) throws IOException {
        return new ARTICLE(this.writer, attr);
    }

    public FOOTER footer() throws IOException {
        return new FOOTER(this.writer, new Attr[0]);
    }

    public H h1(Attr ... attr) throws IOException {
        return new H(this.writer, "h1", attr);
    }

    public H h2(Attr ... attr) throws IOException {
        return new H(this.writer, "h2", attr);
    }

    public H h3(Attr ... attr) throws IOException {
        return new H(this.writer, "h3", attr);
    }

    public H h4(Attr ... attr) throws IOException {
        return new H(this.writer, "h4", attr);
    }

    public H h5(Attr ... attr) throws IOException {
        return new H(this.writer, "h5", attr);
    }

    public H h6(Attr ... attr) throws IOException {
        return new H(this.writer, "h6", attr);
    }

    public DIV div(Attr ... attr) throws IOException {
        return new DIV(this.writer, attr);
    }

    public SPAN span(Attr ... attr) throws IOException {
        return new SPAN(this.writer, attr);
    }

    public OL ol(Attr ... attr) throws IOException {
        return new OL(this.writer, attr);
    }

    public UL ul(Attr ... attr) throws IOException {
        return new UL(this.writer, attr);
    }

    public NAV nav(Attr ... attr) throws IOException {
        return new NAV(this.writer, attr);
    }

    public P p(Attr ... attr) throws IOException {
        return new P(this.writer, attr);
    }

    public SECTION section(Attr ... attr) throws IOException {
        return new SECTION(this.writer, attr);
    }

    public AbstractBody img(String src, Attr ... attr) throws IOException {
        this.writer.write("<img src=\"");
        this.writer.write(src);
        this.writer.write("\"");
        Attr.output(this.writer, attr);
        this.writer.write("/>");
        return this;
    }

    public void imgWithAnchor(String cls, String name) throws IOException {
        String path = "../img/" + cls + "/" + name;
        A a = this.a(Attr.href(path), Attr.target("_blank"));
        a.img(path, Attr.alt(name), Attr.clazz(cls));
        a.end();
    }

    public TABLE table(Attr ... attr) throws IOException {
        return new TABLE(this.writer, attr);
    }

    public STRONG strong(Attr ... attr) throws IOException {
        return new STRONG(this.writer, attr);
    }

    public I i(Attr ... attr) throws IOException {
        return new I(this.writer, attr);
    }

    public S s(Attr ... attr) throws IOException {
        return new S(this.writer, attr);
    }

    public FORM form(Attr ... attr) throws IOException {
        return new FORM(this.writer, attr);
    }
}

