/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamResult;
import org.infodb.commons.db.JDBCSupport;
import org.infodb.commons.db.SQLLog;
import org.infodb.commons.db.SQLWhere;
import org.infodb.commons.xml.Transformer;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.SAXException;

public class SQLDML {
    protected String tableName;
    protected ArrayList<FieldPair> columns = new ArrayList();
    protected ArrayList<SQLWhere> whereClause = new ArrayList();

    protected SQLDML() {
    }

    public void setTableName(String initTableName) {
        this.tableName = initTableName;
    }

    public void addWhere(SQLWhere where) {
        this.whereClause.add(where);
    }

    protected String generateInsertSQL() {
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(this.tableName);
        StringBuffer sbCol = new StringBuffer(" (");
        StringBuffer sbVal = new StringBuffer(") VALUES (");
        boolean first = true;
        for (FieldPair fp : this.columns) {
            if (!first) {
                sbCol.append(", ");
                sbVal.append(", ");
            }
            sbCol.append(fp.getName());
            if (fp.getFunc() == null) {
                sbVal.append("?");
            } else {
                sbVal.append(fp.getFunc());
            }
            first = false;
        }
        sb.append(sbCol).append(sbVal).append(")");
        return sb.toString();
    }

    protected String generateUpdateSQL() {
        StringBuffer sb = new StringBuffer("UPDATE ");
        sb.append(this.tableName);
        sb.append(" SET ");
        boolean first = true;
        for (FieldPair fp : this.columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(fp.getName());
            if (fp.getFunc() == null) {
                sb.append(" = ?");
            } else {
                sb.append(" = ");
                sb.append(fp.getFunc());
            }
            first = false;
        }
        first = true;
        for (SQLWhere where : this.whereClause) {
            sb.append(where.getWhereString(first));
            first = false;
        }
        return sb.toString();
    }

    protected String generateDeleteSQL() {
        StringBuffer sb = new StringBuffer("DELETE FROM ");
        sb.append(this.tableName);
        boolean first = true;
        for (SQLWhere where : this.whereClause) {
            sb.append(where.getWhereString(first));
            first = false;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected int paramSetting(PreparedStatement stmt, int index, ParamItem item) throws SQLException {
        block23: {
            block22: {
                if (item.value != null) break block22;
                SQLLog.paramlog(index, "NULL");
                stmt.setNull(index++, item.type);
                break block23;
            }
            switch (item.type) {
                case 2005: {
                    if (!(item.value instanceof XmlBuilder)) ** GOTO lbl29
                    try {
                        SQLLog.paramlog(index, "XmlBuilder");
                        clob = JDBCSupport.createClob(stmt.getConnection());
                        writer = clob.setCharacterStream(1L);
                        try {
                            result = new StreamResult(writer);
                            trans = new Transformer();
                            trans.setResult(result);
                            trans.execute((XmlBuilder)item.value);
                            writer.flush();
                        }
                        finally {
                            writer.close();
                        }
                        stmt.setClob(index++, clob);
                        break;
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    catch (SAXException e) {
                        throw new SQLException(e);
                    }
lbl29:
                    // 1 sources

                    SQLLog.paramlog(index, "CLOB");
                    clob = JDBCSupport.createClob(stmt.getConnection());
                    writer = clob.setCharacterStream(1L);
                    reader = (Reader)item.value;
                    buffer = new char[1024];
                    try {
                        try {
                            while ((len = reader.read(buffer)) > 0) {
                                writer.write(buffer, 0, len);
                            }
                            writer.flush();
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    stmt.setClob(index++, clob);
                    break;
                }
                case 2004: {
                    SQLLog.paramlog(index, "BinaryStream");
                    blob = JDBCSupport.createBlob(stmt.getConnection());
                    os = blob.setBinaryStream(0L);
                    is = (InputStream)item.value;
                    buffer = new byte[1024];
                    try {
                        try {
                            while ((len = is.read(buffer)) > 0) {
                                os.write(buffer, 0, len);
                            }
                            os.flush();
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    stmt.setBlob(index++, blob);
                    break;
                }
                default: {
                    SQLLog.paramlog(index, item.value.toString());
                    stmt.setObject(index++, item.value);
                }
            }
        }
        return index;
    }

    protected int paramSetting(PreparedStatement stmt, int index, FieldPair fp) throws SQLException {
        for (ParamItem item : fp.getParams()) {
            index = this.paramSetting(stmt, index, item);
        }
        return index;
    }

    protected int paramSetting(PreparedStatement stmt, int index) throws SQLException {
        for (FieldPair fp : this.columns) {
            index = this.paramSetting(stmt, index, fp);
        }
        return index;
    }

    protected int whereSetting(PreparedStatement stmt, int index) throws SQLException {
        for (SQLWhere where : this.whereClause) {
            for (Object obj : where.getObjects()) {
                if (obj == null) continue;
                SQLLog.wherelog(index, obj.toString());
                stmt.setObject(index++, obj);
            }
        }
        return index;
    }

    public class FieldPair {
        private String name;
        private String func;
        private ArrayList<ParamItem> params;

        public FieldPair(String initName, String initFunc) {
            this.name = initName;
            this.func = initFunc;
            this.params = new ArrayList();
        }

        public FieldPair addParam(Object param, int type) {
            this.params.add(new ParamItem(param, type));
            return this;
        }

        public ArrayList<ParamItem> getParams() {
            return this.params;
        }

        public String getName() {
            return this.name;
        }

        public String getFunc() {
            return this.func;
        }
    }

    public class ParamItem {
        Object value;
        int type;

        public ParamItem(Object val, int t) {
            this.value = val;
            this.type = t;
        }
    }
}

