/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infodb.commons.xml.DefaultWalkerFactory;
import org.infodb.commons.xml.DocumentListener;
import org.infodb.commons.xml.ElementWalker;
import org.infodb.commons.xml.NamespaceResolver;
import org.infodb.commons.xml.Owner;
import org.infodb.commons.xml.WalkerHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    protected static Log log = LogFactory.getLog((String)"org.infodb.commons.xml");
    private SAXParserFactory factory = SAXParserFactory.newInstance();
    private SAXParser parser = null;
    private DefaultWalkerFactory defWalker = null;
    private Owner owner = null;
    private NamespaceResolver resolver = null;
    private DocumentListener docListener = null;
    private WalkerHelper current = null;
    private WalkerHelper top = null;

    public Parser() throws ParserConfigurationException, SAXException {
        this.factory.setNamespaceAware(true);
        this.parser = this.factory.newSAXParser();
    }

    public void setDefaultWalkerFactory(DefaultWalkerFactory dwf) {
        this.defWalker = dwf;
    }

    public void setNamespaceResolver(NamespaceResolver nsrslv) {
        this.resolver = nsrslv;
    }

    public void setOwner(Owner o) {
        this.owner = o;
    }

    public void setDocmentListener(DocumentListener l) {
        this.docListener = l;
    }

    public void parse(File f) throws SAXException, IOException {
        this.parser.parse(f, (DefaultHandler)this);
    }

    public void parse(InputStream is) throws SAXException, IOException {
        this.parser.parse(is, (DefaultHandler)this);
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this.parser.parse(new InputSource(reader), (DefaultHandler)this);
    }

    public ElementWalker getRootElement() {
        if (this.top == null) {
            return null;
        }
        return this.top.getWalker();
    }

    public void reset() {
        this.top = null;
    }

    private ElementWalker newInstance(String uri, String localName) throws SAXException {
        String pkgName = this.resolver.getPackageName(uri);
        if (pkgName == null) {
            if (this.defWalker != null) {
                ElementWalker walker = this.defWalker.newDefaultWalker();
                return walker;
            }
            return null;
        }
        StringBuffer sb = new StringBuffer(pkgName);
        sb.append(".");
        sb.append(Parser.capitalize(localName));
        String className = sb.toString();
        try {
            ElementWalker walker = (ElementWalker)Class.forName(className, true, this.resolver.getClass().getClassLoader()).newInstance();
            return walker;
        }
        catch (Exception e) {
            if (this.defWalker != null) {
                ElementWalker walker = this.defWalker.newDefaultWalker();
                return walker;
            }
            throw new SAXException(e.getMessage(), e);
        }
    }

    private static String capitalize(String name) {
        int length = name.length();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                sb.append(Character.toUpperCase(name.charAt(i)));
                first = false;
                continue;
            }
            if (name.charAt(i) == '-') {
                first = true;
                continue;
            }
            sb.append(name.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.docListener != null) {
            this.docListener.endDocument();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.factory == null) {
            throw new SAXException("The Factory class is not registered.");
        }
        if (this.docListener != null) {
            this.docListener.startDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        WalkerHelper helper = new WalkerHelper();
        ElementWalker walker = this.newInstance(uri, localName);
        if (walker == null) {
            throw new SAXException(MessageFormat.format("The ElementWalker has not been created. ns={0}, localName={1}", uri, localName));
        }
        helper.init(this.owner, this.top, this.current, walker);
        this.current = helper;
        if (this.top == null) {
            this.top = helper;
        }
        helper.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.endElement(uri, localName, qName);
        this.current = this.current.getParent();
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this.current.characters(new String(arg0, arg1, arg2));
    }
}

