// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.display.Sprite;
import flash.display.Stage;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

/**
  Edit Window
**/

class WMEdit extends Sprite {
  private var wm:Watermelon;

  /**
    background color
  **/
  @:isVar public var bgColor( get, set ):Int;
    /**
      getter of `bgColor`
    **/
    public function get_bgColor():Int { return( bgColor ); }
    /**
      setter of `bgColor`
    **/
    public function set_bgColor( c:Int ):Int {
      bgColor = c;
      return( bgColor );
    }

  /**
    background alpha coefficient
  **/
  @:isVar public var bgAlpha( get, set ):Float;
    /**
      getter of `bgAlpha`
    **/
    public function get_bgAlpha():Float { return( bgAlpha ); }
    /**
      setter of `bgAlpha`
    **/
    public function set_bgAlpha( a:Float ):Float {
      bgAlpha = a;
      return( bgAlpha );
    }

  /**
    font name
  **/
  @:isVar public var fontname( get, set ):String;
    /**
      getter of `fontname`
    **/
    public function get_fontname():String { return( fontname ); }
    /**
      setter of `fontname`
    **/
    public function set_fontname( f:String ):String {
      fontname = f;
      return( fontname );
    }

  /**
    font size for main text
  **/
  @:isVar public var fontsizemain( get, set ):Float;
    /**
      getter of `fontsizemain`
    **/
    public function get_fontsizemain():Float { return( fontsizemain ); }
    /**
      setter of `fontsizemain`
    **/
    public function set_fontsizemain( s:Float ):Float {
      fontsizemain = s;
      return( fontsizemain );
    }

  /**
    font size for buttons
  **/
  @:isVar public var fontsizebutton( get, set ):Float;
    /**
      getter of `fontsizebutton`
    **/
    public function get_fontsizebutton():Float { return( fontsizebutton ); }
    /**
      setter of `fontsizebutton`
    **/
    public function set_fontsizebutton( s:Float ):Float {
      fontsizebutton = s;
      return( fontsizebutton );
    }

  /**
    font color for main (xml) text
  **/
  @:isVar public var fontcolormain( get, set ):Int;
    /**
      getter of `fontcolormain`
    **/
    public function get_fontcolormain():Int { return( fontcolormain ); }
    /**
      setter of `fontcolormain`
    **/
    public function set_fontcolormain( c:Int ):Int {
      fontcolormain = c;
      return( fontcolormain );
    }

  /**
    font colors for buttons
  **/
  @:isVar public var fontcolorbutton( get, set ):Int;
    /**
      getter for `fontcolorbutton`
    **/
    public function get_fontcolorbutton():Int { return( fontcolorbutton ); }
    /**
      setter for `fontcolorbutton`
    **/
    public function set_fontcolorbutton( c:Int ):Int {
      fontcolorbutton = c;
      return( fontcolorbutton );
    }

  /**
    textfield window size ratio for x direction
  **/
  @:isVar public var ratio_windowsize_x( get, set ):Float;
    /**
      getter for `ratio_windowsize_x`
    **/
    public function get_ratio_windowsize_x():Float { return( ratio_windowsize_x ); }
    /**
      setter for `ratio_windowsize_x`
    **/
    public function set_ratio_windowsize_x( r:Float ):Float {
      ratio_windowsize_x = r;
      return( ratio_windowsize_x );
    }

  /**
    textfield window size ratio for y direction
  **/
  @:isVar public var ratio_windowsize_y( get, set ):Float;
    /**
      getter for `ratio_windowsize_y`
    **/
    public function get_ratio_windowsize_y():Float { return( ratio_windowsize_y ); }
    /**
      setter for `ratio_windowsize_y`
    **/
    public function set_ratio_windowsize_y( r:Float ):Float {
      ratio_windowsize_y = r;
      return( ratio_windowsize_y );
    }

  /**
    origin of textfield position for x direction, in relative manner
  **/
  @:isVar public var ratio_windowpos_x( get, set ):Float;
    /**
      getter of `ratio_windowpos_x`
    **/
    public function get_ratio_windowpos_x():Float { return( ratio_windowpos_x ); }
    /**
      setter of `ratio_windowpos_x`
    **/
    public function set_ratio_windowpos_x( r:Float ):Float {
      ratio_windowpos_x = r;
      return( ratio_windowpos_x );
    }

  /**
    origin of textfield position for y direction, in relative manner
  **/
  @:isVar public var ratio_windowpos_y( get, set ):Float;
    /**
      getter of `ratio_windowpos_y`
    **/
    public function get_ratio_windowpos_y():Float { return( ratio_windowpos_y ); }
    /**
      setter of `ratio_windowpos_y`
    **/
    public function set_ratio_windowpos_y( r:Float ):Float {
      ratio_windowpos_y = r;
      return( ratio_windowpos_y );
    }

  /**
    OK button position of x direction in ratio
  **/
  @:isVar public var ratio_ok_pos_x( get, set ):Float;
    /**
      getter of `ratio_ok_pos_x`
    **/
    public function get_ratio_ok_pos_x():Float { return( ratio_ok_pos_x ); }
    /**
      setter of `ratio_ok_pos_x`
    **/
    public function set_ratio_ok_pos_x( r:Float ):Float {
      ratio_ok_pos_x = r;
      return( ratio_ok_pos_x );
    }

  /**
    OK button position of y direction in ratio
  **/
  @:isVar public var ratio_ok_pos_y( get, set ):Float;
    /**
      getter of `ratio_ok_pos_y`
    **/
    public function get_ratio_ok_pos_y():Float { return( ratio_ok_pos_y ); }
    /**
      setter of `ratio_ok_pos_y`
    **/
    public function set_ratio_ok_pos_y( r:Float ):Float {
      ratio_ok_pos_y = r;
      return( ratio_ok_pos_y );
    }

  /**
    Cancel button position of x direction in ratio
  **/
  @:isVar public var ratio_cancel_pos_x( get, set ):Float;
    /**
      getter of `ratio_cancel_pos_x`
    **/
    public function get_ratio_cancel_pos_x():Float { return( ratio_cancel_pos_x ); }
    /**
      setter of `ratio_cancel_pos_x`
    **/
    public function set_ratio_cancel_pos_x( r:Float ):Float {
      ratio_cancel_pos_x = r;
      return( ratio_cancel_pos_x );
    }

  /**
    Cancel button position of y direction in ratio
  **/
  @:isVar public var ratio_cancel_pos_y( get, set ):Float;
    /**
      getter of `ratio_cancel_pos_y`
    **/
    public function get_ratio_cancel_pos_y():Float { return( ratio_cancel_pos_y ); }
    /**
      setter of `ratio_cancel_pos_y`
    **/
    public function set_ratio_cancel_pos_y( r:Float ):Float {
      ratio_cancel_pos_y = r;
      return( ratio_cancel_pos_y );
    }

  // ####################################################################

  /**
    Constructor. Parent Watermelon must be given by `melon`.

    Default values:

    - bgColor: 0x00FF00
    - bgalpha: 0.5
    - fontname: "Arial"
    - fontsizemain: 12
    - fontsizebutton: 16
    - fontcolormain: 0x000000
    - fontcolorbutton: 0x000000
    - ratio_windowsize_x: 0.7
    - ratio_windowsize_y: 0.7
    - ratio_windowpos_x: 0.1
    - ratio_windowpos_y: 0.1
    - ratio_ok_pos_x: 0.6
    - ratio_ok_pos_y: 0.85
    - ratio_cancel_pos_x: 0.7
    - ratio_cancel_pos_y: 0.85
  **/
  public function new( melon:Watermelon ) {
    super();
    wm = melon;

    // default values
    bgColor = 0x00FF00;
    bgAlpha = 0.5;
    fontname = "Arial";
    fontsizemain = 12;
    fontsizebutton = 16;
    fontcolormain = 0x000000;
    fontcolorbutton = 0x000000;
    ratio_windowsize_x = 0.7;
    ratio_windowsize_y = 0.7;
    ratio_windowpos_x = 0.1;
    ratio_windowpos_y = 0.1;
    ratio_ok_pos_x = 0.6;
    ratio_ok_pos_y = 0.85;
    ratio_cancel_pos_x = 0.7;
    ratio_cancel_pos_y = 0.85;
  }

  /**
    draw edit window
  **/
  public function draw() {
    this.graphics.clear();
    this.removeChildren();

    fillBackground();
    createTextField();
    createOKButton();
    createCancelButton();

    return( this );
  }

  private function fillBackground():Void {
    this.graphics.beginFill( bgColor, bgAlpha );
    this.graphics.drawRect( 0, 0, wm.stage.stageWidth, wm.stage.stageHeight );
    this.graphics.endFill();
  }

  private function createTextField():Void {
    var tf:wmutil.TextFieldWithScrollBar =
        new wmutil.TextFieldWithScrollBar( this,
            new TextFormat( fontname, fontsizemain, fontcolormain ),
            ratio_windowsize_x * wm.stage.stageWidth,
            ratio_windowsize_y * wm.stage.stageHeight,
            12, wm.myString );
    tf.name = "EDIT_WINDOW";
    tf.x = ratio_windowpos_x * wm.stage.stageWidth;
    tf.y = ratio_windowpos_y * wm.stage.stageHeight;
    this.addChild( tf );
  }

  private function createOKButton():Void {
    var ok:TextField = new TextField();
    ok.border = true;
    ok.background = true;
    ok.text = "OK";
    ok.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    ok.selectable = false;
    ok.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var okbutton:Sprite = new Sprite();
    okbutton.addChild( ok );
    this.addChild( okbutton );
    okbutton.x = ratio_ok_pos_x * wm.stage.stageWidth;
    okbutton.y = ratio_ok_pos_y * wm.stage.stageHeight;
    var ref = this;
    okbutton.addEventListener( MouseEvent.CLICK,
                               function( e:Event ) {
                                 var d:Dynamic = ref.getChildByName( "EDIT_WINDOW" );
                                 var s:String = d.getText();
                                 ref.wm.states.busyNow = false;
                                 ref.wm.stage.removeChild( ref );
                                 ref.wm.visualize( s );
                               } );
  }

  private function createCancelButton():Void {
    var cancel:TextField = new TextField();
    cancel.border = true;
    cancel.background = true;
    cancel.text = "Cancel";
    cancel.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    cancel.selectable = false;
    cancel.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var cancelbutton:Sprite = new Sprite();
    cancelbutton.addChild( cancel );
    this.addChild( cancelbutton );
    cancelbutton.x = ratio_cancel_pos_x * wm.stage.stageWidth;
    cancelbutton.y = ratio_cancel_pos_y * wm.stage.stageHeight;
    var ref = this;
    cancelbutton.addEventListener( MouseEvent.CLICK,
                                   function( e:Event ) {
                                     ref.wm.states.busyNow = false;
                                     ref.wm.stage.removeChild( ref );
                                   } );
  }
}
