/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class MemoryMonitor
extends Canvas
implements Runnable {
    static Runtime runtime = Runtime.getRuntime();
    static final int sleepTime = 100;
    static final Color totalColor = Color.blue;
    static final Color usedColor = Color.yellow;
    static final Color totalShadowColor = totalColor.darker().darker();
    static final Color usedShadowColor = usedColor.darker().darker();
    Font labelfont = new Font("Courier", 0, 10);
    Image offscreen;
    int gap = 5;
    int border = 2;
    int grafW = 115;
    int grafH = 115;
    int shadowDepth = 10;
    Thread monitor;
    char[] label = new char[32];
    int labelcount = 0;
    char[] suffixes = "bKMGTP".toCharArray();
    char[] buf = new char[32];
    Dimension size;
    Color fg;
    Color bg;
    FontMetrics fm;
    int[] widths;

    public MemoryMonitor() {
        this.setFont(this.labelfont);
        this.setSize(this.getPreferredSize());
        this.monitor = new Thread(this);
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void suspend() {
        this.monitor.suspend();
    }

    public void resume() {
        this.monitor.resume();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.labelfont = font;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.offscreen != null) {
            this.offscreen.flush();
            this.offscreen = null;
        }
    }

    public void run() {
        while (true) {
            this.updateMemoryMonitor();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    void memstring(long l) {
        int n;
        int n2 = 0;
        while (l >= 8192L) {
            l += 512L;
            l >>= 10;
            ++n2;
        }
        int n3 = 0;
        for (n = (int)l; n >= 10; n /= 10) {
            this.buf[n3++] = (char)(48 + n % 10);
        }
        this.buf[n3++] = (char)(48 + n % 10);
        for (int i = n3 - 1; i >= 0; --i) {
            this.label[this.labelcount++] = this.buf[i];
        }
        this.label[this.labelcount++] = this.suffixes[n2];
    }

    void buildLabel(long l, long l2) {
        this.labelcount = 0;
        this.memstring(l2 - l);
        this.label[this.labelcount++] = 47;
        this.memstring(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMemoryMonitor() {
        block11: {
            Object object;
            if (this.offscreen == null) {
                object = this.getPreferredSize();
                this.offscreen = this.createImage(((Dimension)object).width, ((Dimension)object).height);
                if (this.offscreen == null) {
                    return;
                }
                this.size = this.getSize();
                this.bg = this.getBackground();
                this.fg = this.getForeground();
                this.fm = this.getFontMetrics(this.labelfont);
                this.widths = this.fm.getWidths();
            }
            if ((object = this.offscreen.getGraphics()) != null) {
                try {
                    Graphics graphics;
                    ((Graphics)object).setColor(this.bg);
                    ((Graphics)object).clearRect(0, 0, this.size.width, this.size.height);
                    long l = runtime.totalMemory();
                    long l2 = runtime.freeMemory();
                    int n = (int)(360L * (l - l2) / l);
                    int n2 = this.border + this.gap;
                    int n3 = this.border + this.gap;
                    ((Graphics)object).setColor(totalShadowColor);
                    ((Graphics)object).fillOval(n2 + this.shadowDepth, n3 + this.shadowDepth, this.grafW, this.grafH);
                    ((Graphics)object).setColor(usedShadowColor);
                    ((Graphics)object).fillArc(n2 + this.shadowDepth, n3 + this.shadowDepth, this.grafW, this.grafH, 90, -n);
                    ((Graphics)object).setColor(totalColor);
                    ((Graphics)object).fillOval(n2, n3, this.grafW, this.grafH);
                    ((Graphics)object).setColor(usedColor);
                    ((Graphics)object).fillArc(n2, n3, this.grafW, this.grafH, 90, -n);
                    n3 += this.gap + this.grafH + this.shadowDepth;
                    n2 += this.shadowDepth / 2;
                    if (this.labelfont != null) {
                        this.buildLabel(l2, l);
                        ((Graphics)object).setColor(this.fg);
                        int n4 = 0;
                        for (int i = 0; i < this.labelcount; ++i) {
                            n4 += this.widths[this.label[i]];
                        }
                        ((Graphics)object).drawChars(this.label, 0, this.labelcount, n2 += this.grafW / 2 - n4 / 2, n3 + this.fm.getMaxAscent());
                    }
                    if ((graphics = this.getGraphics()) == null) break block11;
                    try {
                        graphics.drawImage(this.offscreen, 0, 0, null);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        int n = this.grafW + this.shadowDepth + 2 * this.border + 2 * this.gap;
        int n2 = this.grafH + this.shadowDepth + 2 * this.border + 3 * this.gap;
        if (this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n = Math.max(n, fontMetrics.stringWidth("XXXK / XXXM") + 2 * this.border + 2 * this.gap);
            n2 += fontMetrics.getHeight();
        }
        return new Dimension(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.clearRect(0, 0, dimension.width, dimension.height);
    }
}

