/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NXMLOutputHandler
implements OutputDocumentHandler {
    private Writer writer;
    private boolean keepOpen;
    private final char[] chBuf = new char[1];
    private final String lineSeparator = System.getProperty("line.separator");
    private String[] escapes = new String[128];
    private final EscapeCharacterHandler escapeCharacterHandler = new EscapeCharacterHandler();
    private final CharacterHandler ignoreCharacterHandler = new CharacterHandler();
    private final CharacterHandler dataCharacterHandler = new DataCharacterHandler();
    private CharacterHandler controlCharacterHandler;
    private CharacterHandler characterHandler;
    private int depth = 0;
    private CharacterHandler[] characterHandlers = new CharacterHandler[1];

    public NXMLOutputHandler() {
        this.characterHandler = this.ignoreCharacterHandler;
        if (!this.lineSeparator.equals("\n")) {
            this.escapes[10] = this.lineSeparator;
            this.controlCharacterHandler = new LineControlCharacterHandler();
        } else {
            this.controlCharacterHandler = new ControlCharacterHandler();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.characterHandler.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("control") || string.equals("data")) {
            this.pop();
        } else if (string.equals("escape")) {
            this.escapeCharacterHandler.endChar();
            this.pop();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        String string = attributeList.getValue("media-type");
        if (string == null) {
            string = "text/plain";
        }
        this.writer = new BufferedWriter(destination.getWriter(string, attributeList.getValue("encoding")));
        this.keepOpen = destination.keepOpen();
        return this;
    }

    public void pop() {
        this.characterHandler = this.characterHandlers[--this.depth];
    }

    public void processingInstruction(String string, String string2) {
    }

    public void push(CharacterHandler characterHandler) {
        if (this.depth >= this.characterHandlers.length) {
            CharacterHandler[] characterHandlerArray = this.characterHandlers;
            this.characterHandlers = new CharacterHandler[characterHandlerArray.length * 2];
            System.arraycopy(characterHandlerArray, 0, this.characterHandlers, 0, characterHandlerArray.length);
        }
        this.characterHandlers[this.depth++] = this.characterHandler;
        this.characterHandler = characterHandler;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        block4: {
            String string2;
            block6: {
                block5: {
                    block3: {
                        if (!string.equals("control")) break block3;
                        this.push(this.controlCharacterHandler);
                        break block4;
                    }
                    if (!string.equals("data")) break block5;
                    this.push(this.dataCharacterHandler);
                    break block4;
                }
                if (!string.equals("escape")) break block6;
                this.escapeCharacterHandler.setChar(attributeList.getValue("char"));
                this.push(this.escapeCharacterHandler);
                break block4;
            }
            if (!string.equals("char") || (string2 = attributeList.getValue("number")) == null) break block4;
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0 && n < 65536) {
                    this.chBuf[0] = (char)n;
                    this.characters(this.chBuf, 0, 1);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    class CharacterHandler {
        CharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
        }
    }

    class EscapeCharacterHandler
    extends CharacterHandler {
        private int c;
        private StringBuffer buf = new StringBuffer();

        EscapeCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) {
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    this.buf.append(NXMLOutputHandler.this.lineSeparator);
                } else {
                    this.buf.append(cArray[n]);
                }
                ++n;
                --n2;
            }
        }

        void endChar() {
            if (this.c >= 0) {
                if (this.c >= NXMLOutputHandler.this.escapes.length) {
                    int n = NXMLOutputHandler.this.escapes.length;
                    while ((n *= 2) <= this.c) {
                    }
                    String[] stringArray = NXMLOutputHandler.this.escapes;
                    NXMLOutputHandler.this.escapes = new String[n];
                    System.arraycopy(stringArray, 0, NXMLOutputHandler.this.escapes, 0, stringArray.length);
                }
                ((NXMLOutputHandler)NXMLOutputHandler.this).escapes[this.c] = this.buf.toString();
            }
        }

        void setChar(String string) {
            this.buf.setLength(0);
            this.c = string.length() == 0 ? -1 : (int)string.charAt(0);
        }
    }

    class DataCharacterHandler
    extends CharacterHandler {
        DataCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            String[] stringArray = NXMLOutputHandler.this.escapes;
            int n3 = n;
            while (n2 > 0) {
                String string;
                char c = cArray[n];
                if (c < stringArray.length && (string = stringArray[c]) != null) {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(string);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }
    }

    class ControlCharacterHandler
    extends CharacterHandler {
        ControlCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            NXMLOutputHandler.this.writer.write(cArray, n, n2);
        }
    }

    class LineControlCharacterHandler
    extends CharacterHandler {
        LineControlCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(NXMLOutputHandler.this.lineSeparator);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }
    }
}

